/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl.beanimport;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.kportal.extension.module.bean.FicheBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.univ.objetspartages.bean.RubriquepublicationBean;
import com.univ.objetspartages.om.AbstractFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.utils.ContexteDao;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBeanImportFiche
implements ServiceBeanImport<FicheBeanExport<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBeanImportFiche.class);

    @Override
    public String importBeanExport(AbstractBeanExport<?> beanExport, String pathImport) {
        FicheBeanExport ficheBeanExport = (FicheBeanExport)beanExport;
        try (ContexteDao contexteDao = new ContexteDao();){
            UASOmHelper.addMetatagBean(contexteDao, ficheBeanExport.getMetatag());
            this.addFicheUniv(contexteDao, ficheBeanExport);
            UASOmHelper.addAllRessourceMediaBean(contexteDao, ficheBeanExport.getRessources(), ficheBeanExport.getMedias(), pathImport);
            this.addRubriquePublication(contexteDao, ficheBeanExport);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Une erreur est survenue lors de l'import de la fiche \"%s\"", ficheBeanExport), (Throwable)e);
        }
        return null;
    }

    private void addFicheUniv(ContexteDao contexteDao, FicheBeanExport<?> ficheBeanExport) throws Exception {
        FicheUniv fiche = ReferentielObjets.instancierFiche(ficheBeanExport.getTypeObjet());
        fiche.init();
        fiche.setCtx(contexteDao);
        if (fiche instanceof AbstractFiche) {
            AbstractFiche finalFiche = (AbstractFiche)fiche;
            UASOmHelper.copyProperties(finalFiche.getPersistenceBean(), ficheBeanExport.getBean());
        } else {
            UASOmHelper.copyProperties(fiche, ficheBeanExport.getBean());
        }
        fiche.add();
    }

    private void addRubriquePublication(ContexteDao contexteDao, FicheBeanExport<?> ficheBeanExport) throws Exception {
        if (CollectionUtils.isNotEmpty(ficheBeanExport.getRubriquespublication())) {
            for (RubriquepublicationBean currentRubriquepublicationBean : ficheBeanExport.getRubriquespublication()) {
                Rubriquepublication rubriquePublication = new Rubriquepublication();
                rubriquePublication.init();
                rubriquePublication.setCtx(contexteDao);
                UASOmHelper.copyProperties(rubriquePublication, currentRubriquepublicationBean);
                rubriquePublication.add();
            }
        }
    }
}

