/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.module.service.impl.beanimport;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.kportal.extension.module.bean.RubriqueBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.univ.objetspartages.bean.RubriqueBean;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBeanImportRubrique
implements ServiceBeanImport<RubriqueBeanExport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBeanImportRubrique.class);

    @Override
    public String importBeanExport(AbstractBeanExport<?> beanExport, String pathImport) {
        RubriqueBeanExport rubriqueBeanExport = (RubriqueBeanExport)beanExport;
        try (ContexteDao contexteDao = new ContexteDao();){
            this.addRubrique(contexteDao, (RubriqueBean)rubriqueBeanExport.getBean(), rubriqueBeanExport.isRubriqueSite());
            UASOmHelper.addAllMediaBean(contexteDao, rubriqueBeanExport.getMedias(), pathImport);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Une erreur est survenue lors de l'import de la rubrique \"%s\"", rubriqueBeanExport), (Throwable)e);
        }
        if (rubriqueBeanExport.isRubriqueSite()) {
            return ((RubriqueBean)rubriqueBeanExport.getBean()).getCode();
        }
        return null;
    }

    private void addRubrique(ContexteDao contexteDao, RubriqueBean rubriqueBean, boolean isRubriqueSite) throws Exception {
        Rubrique rubrique = new Rubrique();
        rubrique.init();
        rubrique.setCtx(contexteDao);
        UASOmHelper.copyProperties(rubrique, rubriqueBean);
        if (isRubriqueSite) {
            rubrique.setIntitule(String.format("%s [Copie]", rubrique.getIntitule()));
        }
        rubrique.add();
    }
}

