/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.Formateur;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.exception.NoSuchExtensionException;
import com.kportal.extension.sgbd.ExtensionDB;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import org.apache.commons.lang3.StringUtils;

public class Extension
extends ExtensionDB
implements Cloneable {
    private static final long serialVersionUID = -996480676318427303L;

    public void init() {
        this.setIdExtension(0L);
        this.setIdBean("");
        this.setLibelle("");
        this.setDateCreation(new Date(0L));
        this.setDateModification(new Date(0L));
        this.setEtat(1);
        this.setType(1);
        this.setTables("");
    }

    public String getLibelleAffichable(String key) {
        return ExtensionHelper.getMessage(this.getIdBean(), key);
    }

    public int select(String idBean, String libelle, Date dateCreation, Date dateModification, Integer etat, Integer[] type, String nombre, String order) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)idBean)) {
            where.and(ConditionHelper.egalVarchar("T1.ID_BEAN", idBean));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.likePourValeursMultiple("T1.LIBELLE", libelle));
        }
        if (Formateur.estSaisie(dateCreation)) {
            where.and(ConditionHelper.critereDateDebut("T1.DATE_CREATION", dateCreation));
        }
        if (Formateur.estSaisie(dateModification)) {
            where.and(ConditionHelper.critereDateDebut("T1.DATE_MODIFICATION", dateModification));
        }
        if (etat != null) {
            where.and(ConditionHelper.egal("T1.ETAT", etat, TypeOperande.INTEGER));
        }
        if (type != null) {
            ConditionList conditionsSurTypes = new ConditionList();
            for (Integer integer : type) {
                conditionsSurTypes.or(ConditionHelper.egal("T1.TYPE", integer, TypeOperande.INTEGER));
            }
            where.and(conditionsSurTypes);
        }
        requeteSelect.where(where);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            orderBy = OrderByHelper.reconstruireClauseOrderBy(order);
        } else {
            orderBy.orderBy("T1.LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        }
        requeteSelect.orderBy(orderBy);
        ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation(this.ctx, nombre);
        requeteSelect.limit(limite);
        return this.select(requeteSelect.formaterRequete());
    }

    public Extension clone() throws CloneNotSupportedException {
        return (Extension)super.clone();
    }

    public Extension setConfig() throws Exception {
        IExtension extension = this.getExtension();
        if (extension == null) {
            throw new NoSuchExtensionException(this.getIdBean());
        }
        this.setAuteur(extension.getAuteur());
        this.setLibelle(extension.getLibelle());
        this.setDescription(extension.getDescription());
        if (StringUtils.isNotBlank((CharSequence)extension.getLogo())) {
            this.setLogo(extension.getRelativePath() + extension.getLogo());
        }
        this.setUrl(extension.getUrl());
        this.setCoreVersion(extension.getCoreVersion());
        return this;
    }

    public IExtension getExtension() {
        return (IExtension)ApplicationContextManager.getBean(this.getIdBean(), this.getIdBean());
    }
}

