/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.Formateur;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.context.OverridedContextBean;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.module.IModule;
import com.kportal.extension.om.Extension;
import com.kportal.extension.sgbd.ModuleDB;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Date;
import org.apache.commons.lang3.StringUtils;

public class Module
extends ModuleDB
implements Cloneable {
    private static final String NB_CE_MODULE_SURCHARGE_LE_MODULE = "BO_EXTENSION_MODULE_SURCHARGE_LE_MODULE";
    private static final String DE_L_EXTENSION = "BO_EXTENSION_DE_L_EXTENSION";
    private static final String NB_CE_MODULE_EST_SURCHARGE_PAR_LE_MODULE = "BO_EXTENSION_MODULE_SURCHARGE_PAR_LE_MODULE";
    private static final long serialVersionUID = -5992754650636410517L;

    public void init() {
        this.setIdModule(0L);
        this.setIdBean("");
        this.setIdExtension(0L);
        this.setLibelle("");
        this.setDateCreation(new Date(0L));
        this.setDateModification(new Date(0L));
        this.setEtat(1);
        this.setType(-1);
    }

    public String getLibelleAffichable(String key) {
        return ExtensionHelper.getMessage(this.getIdBeanExtension(), key);
    }

    public int select(String idBean, Long idExtension, String libelle, Date dateCreation, Date dateModification, Integer etat, Integer[] type, String nombre) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)idBean)) {
            where.and(ConditionHelper.egalVarchar("T1.ID_BEAN", idBean));
        }
        if (idExtension != null) {
            where.and(ConditionHelper.egal("T1.ID_EXTENSION", idExtension, TypeOperande.LONG));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.likePourValeursMultiple("T1.LIBELLE", libelle));
        }
        if (Formateur.estSaisie(dateCreation)) {
            where.and(ConditionHelper.critereDateDebut("T1.DATE_CREATION", dateCreation));
        }
        if (Formateur.estSaisie(dateModification)) {
            where.and(ConditionHelper.critereDateDebut("T1.DATE_MODIFICATION", dateModification));
        }
        if (etat != null) {
            where.and(ConditionHelper.egal("T1.ETAT", etat, TypeOperande.INTEGER));
        }
        if (type != null) {
            ConditionList conditionsSurTypes = new ConditionList();
            for (Integer integer : type) {
                conditionsSurTypes.or(ConditionHelper.egal("T1.TYPE", integer, TypeOperande.INTEGER));
            }
            where.and(conditionsSurTypes);
        }
        requeteSelect.where(where);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        requeteSelect.orderBy(orderBy);
        ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation(this.ctx, nombre);
        requeteSelect.limit(limite);
        return this.select(requeteSelect.formaterRequete());
    }

    public int selectByExtension(Long idExtension, Integer etat, Integer[] type) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (idExtension != null) {
            where.and(ConditionHelper.egal("T1.ID_EXTENSION", idExtension, TypeOperande.LONG));
        }
        if (etat != null) {
            where.and(ConditionHelper.egal("T1.ETAT", etat, TypeOperande.INTEGER));
        }
        if (type != null) {
            ConditionList conditionsSurTypes = new ConditionList();
            for (Integer integer : type) {
                conditionsSurTypes.or(ConditionHelper.egal("T1.TYPE", integer, TypeOperande.INTEGER));
            }
            where.and(conditionsSurTypes);
        }
        requeteSelect.where(where);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        requeteSelect.orderBy(orderBy);
        return this.select(requeteSelect.formaterRequete());
    }

    public Module clone() throws CloneNotSupportedException {
        return (Module)super.clone();
    }

    public Module setConfig(Extension extension) throws Exception {
        IModule module;
        if (extension == null) {
            extension = this.getExtension();
        }
        if ((module = (IModule)ApplicationContextManager.getBean(extension.getIdBean(), this.getIdBean())) != null) {
            IModule module2;
            String description = "";
            if (module instanceof OverridedContextBean && (module2 = (IModule)ApplicationContextManager.getBean(extension.getIdBean(), this.getIdBean(), false)) != null) {
                if (!module2.equals(module)) {
                    description = module2.getDescription();
                    description = description + MessageHelper.getCoreMessage(NB_CE_MODULE_EST_SURCHARGE_PAR_LE_MODULE) + MessageHelper.getMessage(module.getIdExtension(), module.getLibelle()) + MessageHelper.getCoreMessage(DE_L_EXTENSION) + MessageHelper.getMessage(module.getIdExtension(), module.getLibelleExtension()) + "\"";
                } else {
                    description = module.getDescription();
                    module2 = (IModule)ApplicationContextManager.getBean(((OverridedContextBean)((Object)module)).getIdExtensionToOverride(), ((OverridedContextBean)((Object)module)).getIdBeanToOverride(), false);
                    if (module2 != null) {
                        description = description + MessageHelper.getCoreMessage(NB_CE_MODULE_SURCHARGE_LE_MODULE) + MessageHelper.getMessage(((OverridedContextBean)((Object)module)).getIdExtensionToOverride(), module2.getLibelle()) + MessageHelper.getCoreMessage(DE_L_EXTENSION) + MessageHelper.getMessage(((OverridedContextBean)((Object)module)).getIdExtensionToOverride(), module2.getLibelleExtension()) + "\"";
                    }
                }
            }
            this.setIdBeanExtension(extension.getIdBean());
            this.setDescription(description);
            this.setLibelleExtension(extension.getLibelle());
        }
        return this;
    }

    public Extension getExtension() throws Exception {
        Extension extension = new Extension();
        extension.init();
        extension.setCtx(this.ctx);
        extension.setIdExtension(this.getIdExtension());
        extension.retrieve();
        return extension;
    }
}

