/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.kportal.core.cluster.ClusterHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.exception.NoSuchExtensionException;
import com.kportal.extension.om.Extension;
import com.kportal.extension.om.Module;
import com.kportal.extension.service.EtatModuleHelper;
import com.kportal.extension.service.ServiceExtension;
import com.univ.objetspartages.om.AutorisationBean;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class GestionExtension
extends ProcessusBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GestionExtension.class);
    private static final String ECRAN_LISTE = "LISTE";
    private AutorisationBean autorisations = null;

    public GestionExtension(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    protected boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.action.equals(ECRAN_LISTE)) {
                    this.preparerListe();
                } else if (this.action.equals("ACTIVER_EXTENSION")) {
                    this.traiterActivation();
                } else if (this.action.equals("SUPPRIMER_EXTENSION")) {
                    this.traiterSuppression();
                } else if (this.action.equals("ACTIVER_MODULE")) {
                    this.traiterActivation();
                } else if (this.action.equals("RECHARGER")) {
                    this.traiterRechargement(false);
                } else if (this.action.equals("RESTAURER")) {
                    this.traiterRechargement(true);
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (ErreurAsyncException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void traiterSuppression() throws Exception {
        try {
            String idExtension = this.infoBean.getString("ID_EXTENSION");
            if (StringUtils.isNotEmpty((CharSequence)idExtension)) {
                Extension extension = new Extension();
                extension.init();
                extension.setCtx(this);
                extension.setIdExtension(new Long(idExtension));
                extension.retrieve();
                if (extension.getType() != 1) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                }
                ExtensionHelper.getExtensionManager().removeExtension(extension.getIdBean());
                this.reset();
            }
            this.preparerListe();
        }
        catch (Exception e) {
            throw new ErreurAsyncException("Une erreur s'est produite", e);
        }
    }

    private void traiterActivation() throws Exception {
        try {
            String idExtension = this.infoBean.getString("ID_EXTENSION");
            String idModule = this.infoBean.getString("ID_MODULE");
            if (StringUtils.isNotEmpty((CharSequence)idExtension)) {
                Extension extension = new Extension();
                extension.init();
                extension.setCtx(this);
                extension.setIdExtension(new Long(idExtension));
                extension.retrieve();
                if (extension.getType() != 1) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                }
                if (extension.getEtat() == 1) {
                    extension.setEtat(0);
                } else if (extension.getEtat() == 0) {
                    extension.setEtat(1);
                }
                extension.update();
                EtatModuleHelper.setEtatDB(extension.getEtat(), extension.getIdExtension());
                this.refresh();
            } else if (StringUtils.isNotEmpty((CharSequence)idModule)) {
                Module module = new Module();
                module.init();
                module.setCtx(this);
                module.setIdModule(new Long(idModule));
                module.retrieve();
                if (module.getType() != 1) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                }
                if (module.getEtat() == 1) {
                    module.setEtat(0);
                } else if (module.getEtat() == 0) {
                    module.setEtat(1);
                }
                module.update();
                this.refresh();
            }
            this.preparerListe();
        }
        catch (Exception e) {
            throw new ErreurAsyncException("Une erreur s'est produite", e);
        }
    }

    private void traiterRechargement(boolean reset) throws ErreurAsyncException {
        if (reset) {
            ServiceExtension.setEtatDB(-2);
            EtatModuleHelper.setEtatDB(-2, null);
        }
        this.reset();
        try {
            this.preparerListe();
        }
        catch (Exception e) {
            throw new ErreurAsyncException("Une erreur s'est produite", e);
        }
    }

    private void preparerListe() throws Exception {
        Extension extension = new Extension();
        extension.init();
        extension.setCtx(this);
        LinkedHashMap lstExtension = new LinkedHashMap();
        extension.select("", "", null, null, null, new Integer[]{0, 1}, "", "T1.DATE_CREATION,T1.LIBELLE");
        while (extension.nextItem()) {
            ArrayList<Module> lstModule = new ArrayList<Module>();
            Extension cloneExtention = extension.clone();
            try {
                cloneExtention.setConfig();
                if (cloneExtention.getEtat() == 1) {
                    Module module = new Module();
                    module.init();
                    module.setCtx(this);
                    module.selectByExtension(cloneExtention.getIdExtension(), null, new Integer[]{0, 1});
                    while (module.nextItem()) {
                        try {
                            lstModule.add(module.clone().setConfig(cloneExtention));
                        }
                        catch (NoSuchBeanDefinitionException e) {
                            module.delete();
                        }
                    }
                }
                lstExtension.put(cloneExtention, lstModule);
            }
            catch (NoSuchExtensionException e) {
                extension.delete();
            }
        }
        this.infoBean.set("LISTE_EXTENSIONS", lstExtension);
        this.ecranLogique = ECRAN_LISTE;
    }

    private void reset() {
        ClusterHelper.refresh(ApplicationContextManager.getInstance(), null);
    }

    private void refresh() {
        ClusterHelper.refresh(ExtensionHelper.getExtensionManager(), null);
    }
}

