/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.sgbd;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.extension.bean.ExtensionBean;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ExtensionDB
extends ExtensionBean
implements Serializable {
    private static final long serialVersionUID = 8754735340624208482L;
    protected transient OMContext ctx = null;
    protected transient String qualifier = null;
    private transient ResultSet rs = null;

    public String toString() {
        return this.toString(".");
    }

    public String toString(String aSeparator) {
        return "" + this.getIdExtension() + aSeparator + this.getIdBean() + aSeparator + this.getLibelle() + aSeparator + this.getDateCreation() + aSeparator + this.getDateModification() + aSeparator + this.getEtat() + aSeparator + this.getType() + aSeparator + this.getTables() + aSeparator + this.getVersion();
    }

    public void setCtx(OMContext _ctx) {
        this.ctx = _ctx;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    private Connection getConnection() {
        return this.ctx.getConnection();
    }

    public void add() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("insert into EXTENSION (ID_EXTENSION , ID_BEAN , LIBELLE , DATE_CREATION , DATE_MODIFICATION , ETAT , TYPE , TABLES ,VERSION) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setObject(1, (Object)this.getIdExtension(), -5);
            stmt.setObject(2, (Object)this.getIdBean(), 12);
            stmt.setObject(3, (Object)this.getLibelle(), 12);
            stmt.setObject(4, (Object)this.getDateCreation(), 93);
            stmt.setObject(5, (Object)this.getDateModification(), 93);
            stmt.setObject(6, (Object)this.getEtat(), 4);
            stmt.setObject(7, (Object)this.getType(), 4);
            stmt.setObject(8, (Object)this.getTables(), -1);
            stmt.setObject(9, (Object)this.getVersion(), 12);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public void delete() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("delete from EXTENSION where ID_EXTENSION = ?");
            stmt.setObject(1, (Object)this.getIdExtension(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public String getSQLBaseQuery() {
        return "select distinct T1.ID_EXTENSION, T1.ID_BEAN, T1.LIBELLE, T1.DATE_CREATION, T1.DATE_MODIFICATION, T1.ETAT, T1.TYPE, T1.TABLES, T1.VERSION from " + (this.qualifier == null ? "" : this.qualifier) + "EXTENSION T1 ";
    }

    public boolean nextItem() throws Exception {
        boolean res = false;
        try {
            if (this.rs.next()) {
                this.retrieveFromRS();
                res = true;
            }
        }
        catch (Exception e) {
            throw new Exception("ERROR_IN_METHOD nextItem()", e);
        }
        return res;
    }

    public void retrieve() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("select T1.ID_EXTENSION, T1.ID_BEAN, T1.LIBELLE, T1.DATE_CREATION, T1.DATE_MODIFICATION, T1.ETAT, T1.TYPE, T1.TABLES, T1.VERSION from EXTENSION T1 where T1.ID_EXTENSION = ?");
            stmt.setObject(1, (Object)this.getIdExtension(), -5);
            this.rs = stmt.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("retrieve : METHOD_NO_RESULTS");
            }
            this.retrieveFromRS();
        }
    }

    private void retrieveFromRS() throws Exception {
        try {
            this.setIdExtension(new Long(this.rs.getLong(1)));
            this.setIdBean(this.rs.getString(2));
            this.setLibelle(this.rs.getString(3));
            this.setDateCreation(new Date(this.rs.getTimestamp(4).getTime()));
            this.setDateModification(new Date(this.rs.getTimestamp(5).getTime()));
            this.setEtat(new Integer(this.rs.getInt(6)));
            this.setType(new Integer(this.rs.getInt(7)));
            this.setTables(this.rs.getString(8));
            this.setVersion(this.rs.getString(9));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
        }
    }

    public void selectNoCount(String sqlSuffix) throws Exception {
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
    }

    public int select(String sqlSuffix) throws Exception {
        int count = -1;
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
            this.rs.last();
            count = this.rs.getRow();
            this.rs.beforeFirst();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
        return count;
    }

    public void update() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("update EXTENSION set ID_EXTENSION = ?, ID_BEAN = ?, LIBELLE = ?, DATE_CREATION = ?, DATE_MODIFICATION = ?, ETAT = ?, TYPE = ?, TABLES = ?, VERSION = ? where ID_EXTENSION = ?");
            stmt.setObject(1, (Object)this.getIdExtension(), -5);
            stmt.setObject(2, (Object)this.getIdBean(), 12);
            stmt.setObject(3, (Object)this.getLibelle(), 12);
            stmt.setObject(4, (Object)this.getDateCreation(), 93);
            stmt.setObject(5, (Object)this.getDateModification(), 93);
            stmt.setObject(6, (Object)this.getEtat(), 4);
            stmt.setObject(7, (Object)this.getType(), 4);
            stmt.setObject(8, (Object)this.getTables(), -1);
            stmt.setObject(9, (Object)this.getVersion(), 12);
            stmt.setObject(10, (Object)this.getIdExtension(), -5);
            stmt.executeUpdate();
            stmt.close();
        }
    }
}

