/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.extension.sgbd;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.extension.bean.ModuleBean;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ModuleDB
extends ModuleBean
implements Serializable {
    private static final long serialVersionUID = 5907081374052876657L;
    protected transient OMContext ctx = null;
    protected transient String qualifier = null;
    private transient ResultSet rs = null;

    public String toString() {
        return this.toString(".");
    }

    public String toString(String aSeparator) {
        String s = "" + this.getIdModule() + aSeparator + this.getIdBean() + aSeparator + this.getIdExtension() + aSeparator + this.getLibelle() + aSeparator + this.getDateCreation() + aSeparator + this.getDateModification() + aSeparator + this.getEtat() + aSeparator + this.getType();
        return s;
    }

    public void setCtx(OMContext _ctx) {
        this.ctx = _ctx;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    private Connection getConnection() {
        return this.ctx.getConnection();
    }

    public void add() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("insert into MODULE (ID_MODULE , ID_BEAN , ID_EXTENSION , LIBELLE , DATE_CREATION , DATE_MODIFICATION , ETAT , TYPE ) values (?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setObject(1, (Object)this.getIdModule(), -5);
            stmt.setObject(2, (Object)this.getIdBean(), 12);
            stmt.setObject(3, (Object)this.getIdExtension(), -5);
            stmt.setObject(4, (Object)this.getLibelle(), 12);
            stmt.setObject(5, (Object)this.getDateCreation(), 93);
            stmt.setObject(6, (Object)this.getDateModification(), 93);
            stmt.setObject(7, (Object)this.getEtat(), 4);
            stmt.setObject(8, (Object)this.getType(), 4);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public void delete() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("delete from MODULE where ID_MODULE = ?");
            stmt.setObject(1, (Object)this.getIdModule(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public String getSQLBaseQuery() {
        String query = "select distinct T1.ID_MODULE, T1.ID_BEAN, T1.ID_EXTENSION, T1.LIBELLE, T1.DATE_CREATION, T1.DATE_MODIFICATION, T1.ETAT, T1.TYPE from " + (this.qualifier == null ? "" : this.qualifier) + "MODULE T1 ";
        return query;
    }

    public boolean nextItem() throws Exception {
        boolean res = false;
        try {
            if (this.rs.next()) {
                this.retrieveFromRS();
                res = true;
            }
        }
        catch (Exception e) {
            throw new Exception("ERROR_IN_METHOD nextItem()", e);
        }
        return res;
    }

    public void retrieve() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("select T1.ID_MODULE, T1.ID_BEAN, T1.ID_EXTENSION, T1.LIBELLE, T1.DATE_CREATION, T1.DATE_MODIFICATION, T1.ETAT, T1.TYPE from MODULE T1 where T1.ID_MODULE = ?");
            stmt.setObject(1, (Object)this.getIdModule(), -5);
            this.rs = stmt.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("retrieve : METHOD_NO_RESULTS");
            }
            this.retrieveFromRS();
        }
    }

    private void retrieveFromRS() throws Exception {
        try {
            this.setIdModule(new Long(this.rs.getLong(1)));
            this.setIdBean(this.rs.getString(2));
            this.setIdExtension(new Long(this.rs.getLong(3)));
            this.setLibelle(this.rs.getString(4));
            this.setDateCreation(new Date(this.rs.getTimestamp(5).getTime()));
            this.setDateModification(new Date(this.rs.getTimestamp(6).getTime()));
            this.setEtat(new Integer(this.rs.getInt(7)));
            this.setType(new Integer(this.rs.getInt(8)));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
        }
    }

    public void selectNoCount(String sqlSuffix) throws Exception {
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
    }

    public int select(String sqlSuffix) throws Exception {
        int count = -1;
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
            this.rs.last();
            count = this.rs.getRow();
            this.rs.beforeFirst();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
        return count;
    }

    public void update() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("update MODULE set ID_MODULE = ?, ID_BEAN = ?, ID_EXTENSION = ?, LIBELLE = ?, DATE_CREATION = ?, DATE_MODIFICATION = ?, ETAT = ?, TYPE = ? where ID_MODULE = ?");
            stmt.setObject(1, (Object)this.getIdModule(), -5);
            stmt.setObject(2, (Object)this.getIdBean(), 12);
            stmt.setObject(3, (Object)this.getIdExtension(), -5);
            stmt.setObject(4, (Object)this.getLibelle(), 12);
            stmt.setObject(5, (Object)this.getDateCreation(), 93);
            stmt.setObject(6, (Object)this.getDateModification(), 93);
            stmt.setObject(7, (Object)this.getEtat(), 4);
            stmt.setObject(8, (Object)this.getType(), 4);
            stmt.setObject(9, (Object)this.getIdModule(), -5);
            stmt.executeUpdate();
            stmt.close();
        }
    }
}

