/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.frontoffice;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.utils.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicationTemplate {
    private static Logger LOG = LoggerFactory.getLogger(DuplicationTemplate.class);
    private File readDir = null;
    private JspWriter out = null;
    private StringBuffer bilan = null;
    private String oldTemplateJsp = "jsp";
    private String newTemplateJsp = "jsp_new";

    public static void migrer(JspWriter _out, String _oldTemplateJsp, String _newTemplateJsp) throws Exception {
        _out.println("DEBUT du traitement ...<br />");
        _out.flush();
        String readDir = WebAppUtil.getAbsolutePath() + File.separator + _oldTemplateJsp;
        String writeDir = WebAppUtil.getAbsolutePath() + File.separator + _newTemplateJsp;
        File readDirFile = new File(readDir);
        if (!readDirFile.exists()) {
            _out.println("Le r\u00e9pertoire " + readDir + " n'existe pas.");
            return;
        }
        File writeDirFile = new File(writeDir);
        if (writeDirFile.exists()) {
            _out.println("Le r\u00e9pertoire " + writeDir + " existe d\u00e9j\u00e0.");
            return;
        }
        writeDirFile.mkdir();
        DuplicationTemplate migration = new DuplicationTemplate();
        migration.setOut(_out);
        migration.setReadDir(readDirFile);
        migration.setWriteDir(writeDirFile);
        migration.setOldTemplateJsp(_oldTemplateJsp);
        migration.setNewTemplateJsp(_newTemplateJsp);
        ContextePage ctx = new ContextePage("");
        _out.println("<br />*** Duplication du front office ***<br />");
        migration.migrerMethodes();
        _out.println("<br /><br />FIN du traitement.");
        ctx.release();
    }

    public void setReadDir(File readDir) {
        this.readDir = readDir;
    }

    public void migrerMethodes() {
        try {
            this.bilan = new StringBuffer();
            this.processFile(this.readDir);
            this.printlnOut("<br /><br />*** BILAN ***", true);
            this.printlnOut(this.bilan.toString(), true);
            this.out.flush();
        }
        catch (IOException e) {
            LOG.error("erreur lors de l'ecriture sur la sortie", (Throwable)e);
        }
    }

    private void printlnOut(String s, boolean system) {
        try {
            if (system) {
                System.out.println(s);
            }
            this.out.write(s);
            this.out.newLine();
        }
        catch (IOException e) {
            LOG.error("impossible d'\u00e9crire sur la sortie", (Throwable)e);
        }
    }

    private void processFile(File fRead) {
        if (fRead.isDirectory()) {
            String sDir = StringUtils.replace((String)fRead.getAbsolutePath(), (String)(File.separator + this.oldTemplateJsp + File.separator), (String)(File.separator + this.newTemplateJsp + File.separator));
            new File(sDir).mkdir();
            File[] listFiles = fRead.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                if (listFiles[i].isHidden()) continue;
                this.processFile(listFiles[i]);
            }
        } else {
            this.processJsp(fRead);
        }
    }

    private void processJsp(File fRead) {
        File fWrite = new File(fRead.getAbsolutePath() + ".tmp");
        this.printlnOut("<br />Traitement du fichier : " + fRead, true);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fRead));
            BufferedWriter writer = new BufferedWriter(new FileWriter(fWrite));
            String line = null;
            int indiceLine = 1;
            while ((line = reader.readLine()) != null) {
                if (indiceLine > 1) {
                    writer.write("\r\n");
                }
                if (line.indexOf("/" + this.oldTemplateJsp + "/") != -1) {
                    line = line.replaceAll("/" + this.oldTemplateJsp + "/", "/" + this.newTemplateJsp + "/");
                }
                writer.write(line);
                ++indiceLine;
            }
            reader.close();
            writer.flush();
            writer.close();
            String sFile = StringUtils.replace((String)fRead.getAbsolutePath(), (String)(File.separator + this.oldTemplateJsp + File.separator), (String)(File.separator + this.newTemplateJsp + File.separator));
            FileUtil.copierFichier(fWrite, new File(sFile));
            fWrite.delete();
            if (sb.length() > 0) {
                this.bilan.append("<br /><br />Fichier : " + fRead);
                this.bilan.append(sb);
            }
        }
        catch (IOException e) {
            LOG.error("erreur d'\u00e9criture sur le fichier", (Throwable)e);
        }
    }

    public void setOut(JspWriter out) {
        this.out = out;
    }

    public void setOldTemplateJsp(String oldTemplateJsp) {
        this.oldTemplateJsp = oldTemplateJsp;
    }

    public void setNewTemplateJsp(String newTemplateJsp) {
        this.newTemplateJsp = newTemplateJsp;
    }

    public void setWriteDir(File writeDir) {
    }
}

