/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.frontoffice.util;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.cms.objetspartages.ObjetPartageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.module.plugin.objetspartages.IPluginFiche;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.kportal.servlet.BufferedHttpResponseWrapper;
import com.univ.utils.ContexteUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSPIncludeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSPIncludeHelper.class);

    @Deprecated
    public static String getJSPAInclure(InfoBean infoBean, boolean front) throws FileNotFoundException {
        String path = infoBean.getEcranPhysique();
        path = ExtensionHelper.getTemplateExtension(infoBean.getNomExtension(), path, front);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new FileNotFoundException(String.format("pas d'ecran physique trouv\u00e9 pour l'extension : %s, ayant pour \u00e9cran physique d'origine %s, et pour le contexte front %s", infoBean.getNomExtension(), infoBean.getEcranPhysique(), front));
        }
        return path;
    }

    public static String getOutputJsp(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        if (JSPIncludeHelper.isNotValidParameter(context, request, response, path)) {
            return "";
        }
        BufferedHttpResponseWrapper wrapper = new BufferedHttpResponseWrapper(response);
        RequestDispatcher dispatcher = context.getRequestDispatcher(path);
        dispatcher.include((ServletRequest)request, (ServletResponse)wrapper);
        return StringUtils.replaceChars((String)StringUtils.replaceChars((String)wrapper.getOutput(), (String)"\r", (String)""), (String)"\n", (String)"");
    }

    private static boolean isNotValidParameter(ServletContext context, HttpServletRequest request, HttpServletResponse response, String path) {
        return !JSPIncludeHelper.isValide(path) || context == null || request == null || response == null;
    }

    public static void includeJsp(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String path) {
        JSPIncludeHelper.includeJsp(out, context, request, response, path, Boolean.FALSE);
    }

    public static void includeJsp(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String path, boolean valid) {
        if (StringUtils.isEmpty((CharSequence)path) || !valid && !JSPIncludeHelper.isValide(path)) {
            return;
        }
        try {
            out.flush();
            context.getRequestDispatcher(path).include((ServletRequest)request, (ServletResponse)response);
            out.flush();
        }
        catch (Exception e) {
            LOGGER.error("Impossible de faire un include pour le path " + path, (Throwable)e);
        }
    }

    public static void includeObjetTemplate(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String objet, String templateJsp) {
        JSPIncludeHelper.includeJsp(out, context, request, response, ObjetPartageHelper.getTemplateObjet(templateJsp, objet), Boolean.TRUE);
    }

    public static void includeExtensionTemplate(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String idExtension, String pathRelatif) {
        JSPIncludeHelper.includeJsp(out, context, request, response, ExtensionHelper.getTemplateExtension(idExtension, pathRelatif));
    }

    public static void includePluginFicheTemplates(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        if (ContexteUtil.getContexteUniv().getFicheCourante() != null) {
            JSPIncludeHelper.includePluginFicheJsp(out, context, request, response, ContexteUtil.getContexteUniv().getFicheCourante().getClass().getName(), 2);
        }
    }

    public static void includePluginFicheSaisiesBo(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String classe) {
        JSPIncludeHelper.includePluginFicheJsp(out, context, request, response, classe, 0);
    }

    public static void includePluginFicheSaisiesFo(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String classe) {
        JSPIncludeHelper.includePluginFicheJsp(out, context, request, response, classe, 1);
    }

    private static void includePluginFicheJsp(JspWriter out, ServletContext context, HttpServletRequest request, HttpServletResponse response, String classe, int mode) {
        for (IPluginFiche controleur : PluginFicheHelper.getPlugins()) {
            if (!controleur.isActive(classe)) continue;
            String pathRelatif = "";
            switch (mode) {
                case 0: {
                    pathRelatif = controleur.getPathSaisieBo();
                    break;
                }
                case 1: {
                    pathRelatif = controleur.getPathSaisieFo();
                    break;
                }
                case 2: {
                    pathRelatif = controleur.getPathTemplateFo();
                    break;
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)pathRelatif)) continue;
            JSPIncludeHelper.includeJsp(out, context, request, response, ExtensionHelper.getTemplateExtension(controleur.getIdExtension(), pathRelatif), Boolean.TRUE);
        }
    }

    private static boolean isValide(String path) {
        boolean res = Boolean.FALSE;
        String webAppPath = WebAppUtil.getAbsolutePath();
        if (!StringUtils.isEmpty((CharSequence)path) && webAppPath.length() > 0 && new File(webAppPath + path).exists()) {
            res = Boolean.TRUE;
        }
        return res;
    }
}

