/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.service;

import com.kportal.extension.module.composant.ComposantHelper;
import com.kportal.extension.module.composant.IComposant;
import com.kportal.extension.module.composant.Menu;
import com.univ.objetspartages.om.AutorisationBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceMenu {
    public static Menu getMenuBackOfficeParUtilisateur(AutorisationBean autorisation) {
        Menu menuPrincipal = new Menu();
        HashMap<String, Menu> menusPrincipaux = new HashMap<String, Menu>();
        ArrayList<Menu> sousMenus = new ArrayList<Menu>();
        Collection<IComposant> menuNonConstruit = ComposantHelper.getComposants();
        if (CollectionUtils.isNotEmpty(menuNonConstruit)) {
            for (IComposant composant : menuNonConstruit) {
                if (!composant.isVisible(autorisation)) continue;
                Menu menuCourant = ServiceMenu.construitMenuDepuisComposant(composant);
                if (StringUtils.isBlank((CharSequence)composant.getIdMenuBoParent())) {
                    menusPrincipaux.put(composant.getId(), menuCourant);
                    continue;
                }
                sousMenus.add(menuCourant);
            }
            for (Menu menuCourant : sousMenus) {
                Menu menuParent = (Menu)menusPrincipaux.get(menuCourant.getIdMenuParent());
                if (menuParent == null) continue;
                menuParent.addSousMenu(menuCourant);
            }
            for (Menu menuCourant : menusPrincipaux.values()) {
                Collections.sort(menuCourant.getSousMenu());
            }
        }
        menuPrincipal.addAllSousMenu(menusPrincipaux.values());
        Collections.sort(menuPrincipal.getSousMenu());
        return menuPrincipal;
    }

    public static Menu construitMenuDepuisComposant(IComposant composant) {
        Menu menuNiveau = new Menu();
        menuNiveau.setIdMenu(composant.getId());
        menuNiveau.setCode("menu_" + composant.getId());
        menuNiveau.setIdMenuParent(composant.getIdMenuBoParent());
        menuNiveau.setLibelle(composant.getLibelleMenu());
        menuNiveau.setOrdre(composant.getOrdre());
        menuNiveau.setUrl(StringUtils.replace((String)composant.getUrlAccueilBo(), (String)"&", (String)"&amp;"));
        return menuNiveau;
    }
}

