/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.service.impl;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.extension.module.composant.Menu;
import com.kportal.ihm.service.ServiceMenuFront;
import com.univ.multisites.InfosSite;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMenuFrontStandard
implements ServiceMenuFront {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMenuFrontStandard.class);

    @Override
    public Menu getMenuSiteCourant(String nomProprieteSite) {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        return this.getMenuSite(ctx.getInfosSite(), ctx.getLocale(), nomProprieteSite);
    }

    @Override
    public Menu getMenuSite(InfosSite site, String nomProprieteSite) {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        return this.getMenuSite(site, ctx.getLocale(), nomProprieteSite);
    }

    @Override
    public Menu getMenuSite(InfosSite site, Locale langue, String nomProprieteSite) {
        List<String> codesRubriques = site.getProprieteComplementaireListString(nomProprieteSite);
        Menu menuCourant = null;
        try {
            if (CollectionUtils.isNotEmpty(codesRubriques)) {
                for (String codeRubrique : codesRubriques) {
                    Locale localeRubrique;
                    InfosRubriques rubriqueMereMenu = Rubrique.renvoyerItemRubrique(codeRubrique);
                    if (!StringUtils.isNotBlank((CharSequence)rubriqueMereMenu.getCode()) || !langue.equals(localeRubrique = LangueUtil.getLocale(rubriqueMereMenu.getLangue()))) continue;
                    menuCourant = this.getMenuDeuxNiveauParRubrique(rubriqueMereMenu);
                }
            }
        }
        catch (Exception e) {
            LOG.error("impossible de calculer le menu du site courant", (Throwable)e);
        }
        return menuCourant;
    }

    @Override
    public Menu getMenuLangue(InfosSite site, String nomProprieteSite) {
        List<String> codesRubriques = site.getProprieteComplementaireListString(nomProprieteSite);
        Menu menuLangue = null;
        if (CollectionUtils.isNotEmpty(codesRubriques)) {
            ArrayList<String> languesTraitee = new ArrayList<String>();
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            languesTraitee.add(ctx.getLangue());
            try {
                menuLangue = new Menu();
                for (String codeRubrique : codesRubriques) {
                    InfosRubriques rubriqueMereMenu = Rubrique.renvoyerItemRubrique(codeRubrique);
                    if (!StringUtils.isNotBlank((CharSequence)rubriqueMereMenu.getCode()) || languesTraitee.contains(rubriqueMereMenu.getLangue())) continue;
                    menuLangue.addSousMenu(this.creerMenuItemDepuisRubrique(ctx, rubriqueMereMenu));
                    languesTraitee.add(rubriqueMereMenu.getLangue());
                }
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cup\u00e9rer le menu des langues", (Throwable)e);
            }
        }
        return menuLangue;
    }

    protected Menu getMenuDeuxNiveauParRubrique(InfosRubriques rubriqueMereMenu) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        Menu menuPrincipal = this.creerMenuItemDepuisRubrique(ctx, rubriqueMereMenu);
        for (InfosRubriques rubriqueDescendante : rubriqueMereMenu.getListeSousRubriquesFront(ctx)) {
            Menu menuCourant = this.creerMenuItemDepuisRubrique(ctx, rubriqueDescendante);
            for (InfosRubriques sousRubriqueDescendante : rubriqueDescendante.getListeSousRubriquesFront(ctx)) {
                menuCourant.addSousMenu(this.creerMenuItemDepuisRubrique(ctx, sousRubriqueDescendante));
            }
            menuPrincipal.addSousMenu(menuCourant);
        }
        return menuPrincipal;
    }

    protected Menu creerMenuItemDepuisRubrique(ContexteUniv ctx, InfosRubriques rubriqueDescendante) throws Exception {
        Menu lienDuMenu = new Menu();
        lienDuMenu.setLangue(rubriqueDescendante.getLangue());
        lienDuMenu.setLibelle(rubriqueDescendante.getLibelleAffichable());
        lienDuMenu.setType(rubriqueDescendante.getTypeRubrique());
        lienDuMenu.setUrl(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, rubriqueDescendante.getCode()));
        lienDuMenu.setVisuel(Media.getMedia(rubriqueDescendante.getIdMediaBandeau()).getUrlAbsolue());
        lienDuMenu.setCode(rubriqueDescendante.getCode());
        lienDuMenu.setCodeRubriqueOrigine(rubriqueDescendante.getCode());
        return lienDuMenu;
    }

    @Override
    public Menu getMenuParCodeRubrique(String codeRubrique) {
        Menu menuCourant = null;
        if (StringUtils.isNotBlank((CharSequence)codeRubrique)) {
            try {
                InfosRubriques rubriqueMereMenu = Rubrique.renvoyerItemRubrique(codeRubrique);
                menuCourant = this.getMenuDeuxNiveauParRubrique(rubriqueMereMenu);
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cup\u00e9rer le menu depuis le code de rubrique", (Throwable)e);
            }
        }
        return menuCourant;
    }
}

