/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.composant.Composant;
import com.kportal.extension.module.composant.IComposant;
import com.kportal.extension.module.composant.Menu;
import com.kportal.ihm.service.ServiceMenuBack;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.json.CodecJSon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminsiteUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AdminsiteUtils.class);

    public static Menu getMenuActionsCourante(InfoBean infoBean, Hashtable<String, Object> infosSession) {
        AutorisationBean autorisation = (AutorisationBean)infosSession.get("AUTORISATIONS");
        Composant composantCourant = AdminsiteUtils.retrouverComposant(infoBean);
        return composantCourant.getMenuGeneral(autorisation, infoBean);
    }

    public static String getJspBackOffice(InfoBean infoBean) {
        String fichierEcranPhysique = infoBean.getEcranPhysique();
        if (StringUtils.isEmpty((CharSequence)fichierEcranPhysique)) {
            LOG.error("pas d'ecran physique!");
        }
        return "/" + fichierEcranPhysique + ".jsp";
    }

    public static Menu getMenuPrincipalParUtilisateur(Hashtable<String, Object> infosSession) {
        AutorisationBean autorisation = (AutorisationBean)infosSession.get("AUTORISATIONS");
        return ServiceMenuBack.getMenuBackOfficeParUtilisateur(autorisation);
    }

    public static String getTitrePageCourante(InfoBean infoBean) {
        String libelle = "";
        String titreEcran = infoBean.getTitreEcran();
        libelle = StringUtils.isNotBlank((CharSequence)titreEcran) ? titreEcran : AdminsiteUtils.calculerLibelleDepuisLocale(infoBean);
        return libelle;
    }

    private static String calculerLibelleDepuisLocale(InfoBean infoBean) {
        StringBuilder codeLibelle = new StringBuilder();
        String libelle = "";
        String key = "";
        key = StringUtils.isNotEmpty((CharSequence)infoBean.getNomProcessus()) ? infoBean.getNomProcessus() : AdminsiteUtils.retrouverComposant((InfoBean)infoBean).id;
        if (StringUtils.isNotEmpty((CharSequence)infoBean.getEcranLogique())) {
            codeLibelle.append(".").append(infoBean.getEcranLogique());
        }
        if (StringUtils.isNotEmpty((CharSequence)infoBean.getActionUtilisateur())) {
            codeLibelle.append(".").append(infoBean.getActionUtilisateur());
        }
        codeLibelle.insert(0, key);
        if (StringUtils.isNotBlank((CharSequence)codeLibelle.toString()) && StringUtils.isBlank((CharSequence)(libelle = MessageHelper.getMessage(infoBean.getNomExtension(), codeLibelle.toString())))) {
            codeLibelle.replace(0, key.length(), "DEFAUT");
            libelle = MessageHelper.getMessage(infoBean.getNomExtension(), codeLibelle.toString());
        }
        LOG.debug(codeLibelle + " " + libelle);
        return libelle;
    }

    public static Menu getMenuDepuisInfoBean(InfoBean infoBean) {
        Composant composant = AdminsiteUtils.retrouverComposant(infoBean);
        return ServiceMenuBack.construitMenuDepuisComposant(composant);
    }

    public static Composant retrouverComposant(InfoBean infoBean) {
        String idComposant = infoBean.getIdComposant();
        String extension = infoBean.getNomExtension();
        Composant composantCourant = null;
        if (StringUtils.isNotBlank((CharSequence)idComposant)) {
            try {
                composantCourant = StringUtils.isNotEmpty((CharSequence)extension) ? (Composant)ModuleHelper.getModule(extension, idComposant) : (Composant)ModuleHelper.getModule("core", idComposant);
            }
            catch (Exception e) {
                LOG.debug("Impossible de r\u00e9cuperer le composant", (Throwable)e);
            }
        }
        if (composantCourant == null) {
            composantCourant = (Composant)ModuleHelper.getModule("core", "menuAccueil");
        }
        return composantCourant;
    }

    public static boolean isCreationFichePossible(String codeObjet, AutorisationBean autorisation) {
        boolean isCreation = Boolean.FALSE;
        if (StringUtils.isNotBlank((CharSequence)codeObjet)) {
            FicheUniv fiche = ReferentielObjets.instancierFiche(codeObjet);
            isCreation = autorisation.getAutorisation(codeObjet, 0) && !(fiche instanceof FicheObjet);
        }
        return isCreation;
    }

    public static boolean isNotEcranPopup(InfoBean infoBean) {
        return StringUtils.isBlank((CharSequence)infoBean.getString("FCK_PLUGIN")) && StringUtils.isBlank((CharSequence)infoBean.getString("TOOLBOX"));
    }

    public static String getClassMenuBackOffice(Composant composantCourant, Menu menuCourant) {
        String classeComposant = "";
        if (menuCourant.getIdMenu().equals(composantCourant.getIdMenuBoParent()) || menuCourant.getIdMenu().equals(composantCourant.getId())) {
            classeComposant = "focus ";
        }
        if (CollectionUtils.isNotEmpty(menuCourant.getSousMenu())) {
            classeComposant = classeComposant + "sous_menu";
        }
        return classeComposant;
    }

    @Deprecated
    public static Hashtable<String, String> getListeObjetsEditables() {
        Hashtable<String, String> resultat = new Hashtable<String, String>();
        for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
            String url = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + objet.getIdExtension() + "&PROC=" + objet.getParametreProcessus() + "&ACTION=AJOUTER";
            resultat.put(url, objet.getLibelleObjet());
        }
        return resultat;
    }

    public static String getLiensPropagationDeconnexionFormatter() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String urlEnJSON = "";
        try {
            ArrayList<String> urlsDuSite = new ArrayList<String>();
            for (InfosSite infosSite : Site.getListeInfosSites().values()) {
                if (infosSite.getAlias().equals(ctx.getInfosSite().getAlias()) || !infosSite.isSso()) continue;
                urlsDuSite.add(URLResolver.getAbsoluteBoUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=DECONNECTER&REDIRECT=FALSE", infosSite));
            }
            urlEnJSON = CodecJSon.encodeObjectToJSonInString(urlsDuSite);
        }
        catch (Exception e) {
            LOG.error("impossible de charger la liste des sites", (Throwable)e);
        }
        return StringEscapeUtils.escapeHtml4((String)urlEnJSON);
    }

    public static Collection<CritereRecherche> getCriteresRechercheAAfficher(InfoBean infoBean) {
        Object objetCritere = infoBean.get("CRITERE_REQUETE");
        if (objetCritere != null && objetCritere instanceof List) {
            List criteres = (List)objetCritere;
            return CollectionUtils.select((Collection)criteres, (Predicate)new Predicate(){

                public boolean evaluate(Object element) {
                    return ((CritereRecherche)element).isAffichageFront();
                }
            });
        }
        return Collections.emptyList();
    }

    public static String getUrlRechercheAvanceeDatagrid(IComposant module, InfoBean infoBean) {
        List criteres;
        Object objetCritere = infoBean.get("CRITERE_REQUETE");
        String[][] params = new String[][]{};
        if (objetCritere != null && objetCritere instanceof List && !(criteres = (List)objetCritere).isEmpty()) {
            params = new String[criteres.size()][2];
            int i = 0;
            for (CritereRecherche parametre : criteres) {
                params[i] = new String[]{parametre.getNomChamp(), parametre.getValeurARechercher()};
                ++i;
            }
        }
        return ProcessusHelper.getUrlProcessAction(infoBean, module.getIdExtension(), module.getParametreProcessus(), "RECHERCHER", params);
    }

    public static boolean existeAutreLangue(InfoBean infoBean) {
        Hashtable listeAutreLangue = (Hashtable)infoBean.get("LISTE_AUTRES_LANGUES");
        return infoBean.get("FICHES_AUTRE_LANGUE") != null || !"0006".equals(infoBean.get("ETAT_OBJET")) && "1".equals(infoBean.getString("GRS_AUTORISATION_TRADUCTION")) && MapUtils.isNotEmpty((Map)listeAutreLangue);
    }

    public static boolean isSuppressionPossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && ("1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) || "0006".equals(infoBean.get("ETAT_OBJET"))) && !"0004".equals(infoBean.get("ETAT_OBJET"));
    }

    public static boolean isArchivagePossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && !EtatFiche.A_VALIDER.getEtat().equals(infoBean.get("ETAT_OBJET")) && !"0004".equals(infoBean.get("ETAT_OBJET")) && !"0006".equals(infoBean.get("ETAT_OBJET")) && !"0007".equals(infoBean.get("ETAT_OBJET"));
    }

    public static boolean isDuplicationPossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "1".equals(infoBean.getString("GRS_AUTORISATION_DUPLICATION")) && !EtatFiche.A_VALIDER.getEtat().equals(infoBean.get("ETAT_OBJET")) && !"0006".equals(infoBean.get("ETAT_OBJET"));
    }

    public static boolean isPublicationPossible(InfoBean infoBean) {
        return EtatFiche.isEtatEnregistrable(infoBean.getString("ETAT_OBJET")) && ("CREATION".equals(infoBean.getEtatObjet()) || EtatFiche.BROUILLON.getEtat().equals(infoBean.get("ETAT_OBJET")));
    }

    public static boolean isBrouillonPossible(InfoBean infoBean) {
        return AdminsiteUtils.isEnregistrerPossible(infoBean) && !EtatFiche.ARCHIVE.getEtat().equals(infoBean.get("ETAT_OBJET"));
    }

    public static boolean isEnregistrerPossible(InfoBean infoBean) {
        return EtatFiche.isEtatEnregistrable(infoBean.getString("ETAT_OBJET")) && !AdminsiteUtils.isPublicationPossible(infoBean);
    }

    public static boolean isAnnulerSuppressionPossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && "0004".equals(infoBean.get("ETAT_OBJET")) && infoBean.get("AFFICHER_POPUP_RESTAURATION") != null;
    }

    public static boolean isAnnulerSuppressionBrouillonPossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && "0004".equals(infoBean.get("ETAT_OBJET")) && infoBean.get("AFFICHER_POPUP_RESTAURATION") == null;
    }

    public static boolean isRestaurerSauvegardePossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "0006".equals(infoBean.get("ETAT_OBJET")) && infoBean.get("AFFICHER_POPUP_RESTAURATION") != null;
    }

    public static boolean isRestaurerSauvegardeBrouillonPossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "0006".equals(infoBean.get("ETAT_OBJET")) && infoBean.get("AFFICHER_POPUP_RESTAURATION") == null;
    }

    public static boolean isRestaurerArchivePossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && "0007".equals(infoBean.get("ETAT_OBJET")) && infoBean.get("AFFICHER_POPUP_RESTAURATION") != null;
    }

    public static boolean isRestaurerArchiveBrouillonPossible(InfoBean infoBean) {
        return "MODIFICATION".equals(infoBean.getEtatObjet()) && "1".equals(infoBean.getString("GRS_AUTORISATION_SUPPRESSION")) && "0007".equals(infoBean.get("ETAT_OBJET")) && infoBean.get("AFFICHER_POPUP_RESTAURATION") == null;
    }

    public static boolean isValidationPossible(InfoBean infoBean) {
        return EtatFiche.A_VALIDER.getEtat().equals(infoBean.get("ETAT_OBJET")) && "1".equals(infoBean.getString("GRS_AUTORISATION_VALIDATION"));
    }

    public static boolean isAnnulerDemandeValidationPossible(InfoBean infoBean) {
        return EtatFiche.A_VALIDER.getEtat().equals(infoBean.get("ETAT_OBJET")) && !"1".equals(infoBean.getString("GRS_AUTORISATION_VALIDATION"));
    }

    public static boolean isApercuPossible(InfoBean infoBean) {
        return "1".equals(infoBean.getString("GRS_APERCU"));
    }
}

