/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.utils;

import org.apache.commons.lang3.StringUtils;

public final class ColorUtils {
    private static final int RADIX = 16;
    private static final String RGBA_TEMPLATE = "rgba(%s,%s,%s,%s)";
    private static final String COLOR_PREFIX = "#";
    private static final String HSL_TEMPLATE = "hsl(%s,%s%%,%s%%)";
    private static final String RGB_VALUE_REGEXP = "^(?:#|)[0-9a-fA-F]{3}([0-9a-fA-F]{3})?$";

    private ColorUtils() {
    }

    public static String getRGBaFromHexa(String colorToTransform, double alpha) {
        String hex = ColorUtils.getValidRGB(colorToTransform);
        if (StringUtils.isEmpty((CharSequence)hex) || alpha > 1.0) {
            return colorToTransform;
        }
        int r = Integer.valueOf(hex.substring(0, 2), 16);
        int g = Integer.valueOf(hex.substring(2, 4), 16);
        int b = Integer.valueOf(hex.substring(4, 6), 16);
        return String.format(RGBA_TEMPLATE, r, g, b, alpha);
    }

    public static boolean isValidHtmlHexaValue(String colorValue) {
        return StringUtils.isNotBlank((CharSequence)colorValue) && colorValue.matches(RGB_VALUE_REGEXP);
    }

    public static String getHslFromHexa(String colorToTransform, double lumi) {
        String hex = ColorUtils.getValidRGB(colorToTransform);
        if (StringUtils.isEmpty((CharSequence)hex)) {
            return colorToTransform;
        }
        int r = Integer.valueOf(hex.substring(0, 2), 16);
        int g = Integer.valueOf(hex.substring(2, 4), 16);
        int b = Integer.valueOf(hex.substring(4, 6), 16);
        float rp = (float)r / 255.0f;
        float gp = (float)g / 255.0f;
        float bp = (float)b / 255.0f;
        float min = Math.min(rp, Math.min(gp, bp));
        float max = Math.max(rp, Math.max(gp, bp));
        float delta = max - min;
        float h = 0.0f;
        float l = (max + min) / 2.0f;
        if (max == rp) {
            h = 60.0f * ((gp - bp) / delta % 6.0f);
        } else if (max == gp) {
            h = 60.0f * ((bp - rp) / delta + 2.0f);
        } else if (max == bp) {
            h = 60.0f * ((rp - gp) / delta + 4.0f);
        }
        float s = delta == 0.0f ? 0.0f : delta / (1.0f - Math.abs(2.0f * l - 1.0f));
        return String.format(HSL_TEMPLATE, Math.round(h), Float.valueOf(s * 100.0f), (double)(l * 100.0f) + lumi);
    }

    public static String darker(String colorToTransform, double ratio) {
        String newColor = ColorUtils.getValidRGB(colorToTransform);
        if (StringUtils.isNotEmpty((CharSequence)newColor) && ratio >= 0.0 && ratio <= 1.0) {
            String red = StringUtils.substring((String)newColor, (int)0, (int)2);
            String green = StringUtils.substring((String)newColor, (int)2, (int)4);
            String blue = StringUtils.substring((String)newColor, (int)4, (int)6);
            Integer redHexa = Integer.parseInt(red, 16);
            Integer greenHexa = Integer.parseInt(green, 16);
            Integer blueHexa = Integer.parseInt(blue, 16);
            String newRed = ColorUtils.convertIntToColorString((int)((double)redHexa.intValue() - (double)redHexa.intValue() * ratio));
            String newGreen = ColorUtils.convertIntToColorString((int)((double)greenHexa.intValue() - (double)greenHexa.intValue() * ratio));
            String newBlue = ColorUtils.convertIntToColorString((int)((double)blueHexa.intValue() - (double)blueHexa.intValue() * ratio));
            newColor = COLOR_PREFIX + ColorUtils.getValidRGB(newRed + newGreen + newBlue);
        }
        return newColor;
    }

    public static String lighter(String colorToTransform, double ratio) {
        String newColor = ColorUtils.getValidRGB(colorToTransform);
        if (StringUtils.isNotEmpty((CharSequence)newColor) && ratio >= 0.0 && ratio <= 1.0) {
            String red = StringUtils.substring((String)newColor, (int)0, (int)2);
            String green = StringUtils.substring((String)newColor, (int)2, (int)4);
            String blue = StringUtils.substring((String)newColor, (int)4, (int)6);
            Integer redHexa = Integer.parseInt(red, 16);
            Integer greenHexa = Integer.parseInt(green, 16);
            Integer blueHexa = Integer.parseInt(blue, 16);
            String newRed = ColorUtils.convertIntToColorString((int)((double)(255 - redHexa) * ratio + (double)redHexa.intValue()));
            String newGreen = ColorUtils.convertIntToColorString((int)((double)(255 - greenHexa) * ratio + (double)greenHexa.intValue()));
            String newBlue = ColorUtils.convertIntToColorString((int)((double)(255 - blueHexa) * ratio + (double)blueHexa.intValue()));
            newColor = COLOR_PREFIX + ColorUtils.getValidRGB(newRed + newGreen + newBlue);
        }
        return newColor;
    }

    private static String convertIntToColorString(int currentColor) {
        String colorValue = Integer.toHexString(currentColor);
        if (colorValue.length() == 1) {
            colorValue = "0" + colorValue;
        }
        return colorValue;
    }

    private static String getValidRGB(String value) {
        String result = "";
        if (ColorUtils.isValidHtmlHexaValue(value)) {
            String hexaValue = StringUtils.removeStart((String)value, (String)COLOR_PREFIX);
            result = hexaValue.length() == 3 ? hexaValue.substring(0, 1) + hexaValue.substring(0, 1) + hexaValue.substring(1, 2) + hexaValue.substring(1, 2) + hexaValue.substring(2, 3) + hexaValue.substring(2, 3) : hexaValue;
        }
        return result;
    }
}

