/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.utils;

import com.kportal.cms.objetspartages.ObjetPartageHelper;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.frontoffice.util.JSPIncludeHelper;
import com.univ.objetspartages.om.Encadre;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.SousParagrapheBean;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncadresFrontUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EncadresFrontUtils.class);
    public static final String GENERIQUE = "encadre_generique";
    public static final String NAV_AUTO = "encadre_nav_auto";
    public static final String RUBRIQUE = "encadre_rubrique";
    public static final String FICHE = "encadre_fiche";
    public static final String AUTO_FICHE = "encadre_auto_fiche";
    public static final String RECHERCHE_EXTERNE = "encadre_recherche_externe";
    public static final String EXTERNE = "encadre_externe";

    public static Map<String, List<SousParagrapheBean>> getEncadresParType() {
        HashMap<String, List<SousParagrapheBean>> encadresPageCourante = new HashMap<String, List<SousParagrapheBean>>();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        FicheUniv fiche = ctx.getFicheCourante();
        encadresPageCourante.put(GENERIQUE, EncadresFrontUtils.getEncadresGeneriques(ctx, fiche));
        encadresPageCourante.put(NAV_AUTO, EncadresFrontUtils.getEncadreContenuRubrique(ctx));
        encadresPageCourante.put(RUBRIQUE, EncadresFrontUtils.getEncadresRubrique(ctx.getCodeRubriquePageCourante()));
        if (fiche != null) {
            encadresPageCourante.put(FICHE, EncadresFrontUtils.getContenuEncadreFiche(fiche));
        } else {
            encadresPageCourante.put(RECHERCHE_EXTERNE, EncadresFrontUtils.getEncadresRechercheExterne(ctx));
        }
        encadresPageCourante.put(EXTERNE, EncadresFrontUtils.getEncadresExterne(ctx));
        return encadresPageCourante;
    }

    public static String getEncadresAutoFiche(ContexteUniv ctx, FicheUniv fiche) {
        String resultat = "";
        if (fiche != null) {
            String nomObjet = ReferentielObjets.getNomObjet(fiche);
            String path = ObjetPartageHelper.getTemplateObjet(FICHE, nomObjet);
            try {
                resultat = JSPIncludeHelper.getOutputJsp(ctx.getJspWriter(), ctx.getServletContext(), ctx.getRequeteHTTP(), ctx.getReponseHTTP(), path);
            }
            catch (IOException | ServletException e) {
                LOG.error("impossible d'appeler la jsp des encadr\u00e9s automatiques de fiches pour l'objet " + nomObjet, e);
            }
        }
        return resultat;
    }

    public static List<SousParagrapheBean> getContenuEncadreFiche(FicheUniv fiche) {
        ArrayList<SousParagrapheBean> encadres = new ArrayList<SousParagrapheBean>();
        try {
            String contenuEncadreFiche = fiche.getContenuEncadre();
            if (StringUtils.isNotBlank((CharSequence)contenuEncadreFiche)) {
                encadres.addAll(SousParagrapheBean.getSousParagraphes(contenuEncadreFiche));
            }
        }
        catch (Exception e) {
            LOG.error("Impossible de r\u00e9cuperer le contenu de l'encadr\u00e9 de fiche", (Throwable)e);
        }
        return encadres;
    }

    @Deprecated
    public static List<SousParagrapheBean> getEncadreContenuRubrique(ContexteUniv ctx) {
        ArrayList<SousParagrapheBean> encadres = new ArrayList<SousParagrapheBean>();
        try {
            String contenuEncadreRubrique = UnivWebFmt.getEncadreContenuRubriqueCourante(ctx, null, "", "", "", "", "", false, true, false);
            if (StringUtils.isNotBlank((CharSequence)contenuEncadreRubrique)) {
                encadres.addAll(SousParagrapheBean.getSousParagraphes(contenuEncadreRubrique));
            }
        }
        catch (Exception e) {
            LOG.error("Impossible de r\u00e9cuperer le contenu de l'encadre de rubrique", (Throwable)e);
        }
        return encadres;
    }

    public static List<SousParagrapheBean> getEncadresRubrique(String codeRubriquePageCourante) {
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubriquePageCourante);
        ArrayList<SousParagrapheBean> encadres = new ArrayList<SousParagrapheBean>(SousParagrapheBean.getSousParagraphes(rubrique.getEncadre()));
        InfosRubriques rubriqueMere = rubrique;
        while (rubriqueMere.getNiveau() > 0) {
            if (!(rubriqueMere = rubriqueMere.getRubriqueMere()).isEncadreSousRubrique() || !StringUtils.isNotBlank((CharSequence)rubriqueMere.getEncadre())) continue;
            encadres.addAll(SousParagrapheBean.getSousParagraphes(rubriqueMere.getEncadre()));
        }
        return encadres;
    }

    public static List<SousParagrapheBean> getEncadresGeneriques(ContexteUniv ctx, FicheUniv fiche) {
        ArrayList<SousParagrapheBean> encadres = new ArrayList<SousParagrapheBean>();
        try {
            ArrayList<String> encadresFiche = Encadre.getListeEncadres(ctx.getCodeRubriquePageCourante(), fiche, ctx.getLangue());
            for (String contenuEncadre : encadresFiche) {
                if (!StringUtils.isNotBlank((CharSequence)contenuEncadre)) continue;
                encadres.addAll(SousParagrapheBean.getSousParagraphes(contenuEncadre));
            }
        }
        catch (Exception e) {
            LOG.error("Impossible de r\u00e9cuperer les encadr\u00e9s g\u00e9n\u00e9riques ", (Throwable)e);
        }
        return encadres;
    }

    public static List<SousParagrapheBean> getEncadresRechercheExterne(ContexteUniv ctx) {
        ArrayList<SousParagrapheBean> encadres = new ArrayList<SousParagrapheBean>();
        try {
            List<String> encadresExternes = ctx.getEncadresRechercheExternes();
            for (String contenuEncadre : encadresExternes) {
                if (!StringUtils.isNotBlank((CharSequence)contenuEncadre)) continue;
                encadres.addAll(SousParagrapheBean.getSousParagraphes(contenuEncadre));
            }
        }
        catch (Exception e) {
            LOG.error("Impossible de r\u00e9cuperer les encadres de recherche externes", (Throwable)e);
        }
        return encadres;
    }

    public static List<SousParagrapheBean> getEncadresExterne(ContexteUniv ctx) {
        return ctx.getEncadresExternes();
    }

    public static List<String> getEncadresRechercheFiche(FicheUniv fiche) {
        ArrayList<String> encadres = new ArrayList<String>();
        if (fiche != null) {
            List<String> codeObjetsEncadres = EncadresFrontUtils.getCodesObjetsEncadres(fiche);
            for (String codeObjet : codeObjetsEncadres) {
                encadres.add(ObjetPartageHelper.getTemplateObjet("encadre_recherche", ReferentielObjets.getNomObjet(codeObjet)));
            }
        }
        return encadres;
    }

    private static List<String> getCodesObjetsEncadres(FicheUniv fiche) {
        ArrayList<String> codeObjetsEncadres = new ArrayList<String>();
        if (EncadresFrontUtils.isEncadreRechercheEmbarqueValide(fiche.getEncadreRecherche())) {
            codeObjetsEncadres.add(fiche.getEncadreRecherche());
        }
        if (EncadresFrontUtils.isEncadreRechercheEmbarqueValide(fiche.getEncadreRechercheBis())) {
            codeObjetsEncadres.add(fiche.getEncadreRechercheBis());
        }
        if (EncadresFrontUtils.isEncadreRechercheValide(ReferentielObjets.getCodeObjet(fiche))) {
            codeObjetsEncadres.add(ReferentielObjets.getCodeObjet(fiche));
        }
        return codeObjetsEncadres;
    }

    private static boolean isEncadreRechercheEmbarqueValide(String codeEncadreRecherche) {
        boolean isValide = Boolean.FALSE;
        if (StringUtils.isNotBlank((CharSequence)codeEncadreRecherche) && !"0000".equals(codeEncadreRecherche)) {
            try {
                Class<?> classeObjet = Class.forName(ReferentielObjets.getObjetByCode(codeEncadreRecherche).getNomClasse());
                isValide = FicheAnnotationHelper.isEncadreRechercheEmbarquable(classeObjet.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.error("impossible de recuperer les infos des encadres pour le code suivant : " + codeEncadreRecherche, (Throwable)e);
            }
        }
        return isValide;
    }

    private static boolean isEncadreRechercheValide(String codeEncadreRecherche) {
        boolean isValide = Boolean.FALSE;
        try {
            isValide = StringUtils.isNotBlank((CharSequence)codeEncadreRecherche) && !"0000".equals(codeEncadreRecherche) && ReferentielObjets.gereEncadreRecherche(codeEncadreRecherche);
        }
        catch (Exception e) {
            LOG.error("impossible de recuperer les infos des encadres pour le code suivant : " + codeEncadreRecherche, (Throwable)e);
        }
        return isValide;
    }
}

