/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.utils.InfosSiteHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.composant.Menu;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.FichePageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.kportal.ihm.service.MenuFrontFactory;
import com.kportal.ihm.utils.AdminsiteUtils;
import com.kportal.ihm.utils.ClasseFichier;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.LigneContenu;
import com.univ.objetspartages.om.ParagrapheBean;
import com.univ.objetspartages.om.ParagrapheContenuHelper;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FrontUtil.class);
    public static final String NOM_PROPRIETE_LOGO = "LOGO";
    public static final String NOM_PROPRIETE_BASELINE = "BASELINE";
    public static final String NOM_PROPRIETE_COULEUR_PRINCIPALE = "COULEUR_PRINCIPAL";
    public static final String NOM_PROPRIETE_COULEUR_SECONDAIRE = "COULEUR_SECONDAIRE";
    public static final String NOM_PROPRIETE_MENU_PRINCIPAL = "MENU_PRINCIPAL";
    public static final String NOM_PROPRIETE_MENU_PIED_PAGE = "MENU_PIED_PAGE";
    public static final String NOM_PROPRIETE_NIVEAU_MENU_SECONDAIRE = "NIVEAU_MENU_SECONDAIRE";
    public static final String CATEGORIE_NAVIGATION = "NAV";
    public static final String CATEGORIE_LANGUE = "LANGUE";
    public static final String CATEGORIE_ACCES_DIRECT = "ACCES";
    public static final String CATEGORIE_PIED_PAGE = "PIEDPAGE";
    private static final String CATEGORIE_RESEAUX_SOCIAUX = "RX_SOC";
    private static final int NIVEAU_MENU_SECONDAIRE = 2;
    public static final String RGBA_TEMPLATE = "rgba(%s,%s,%s,%s)";
    public static final String COLOR_PREFIX = "#";
    private static final String HSL_TEMPLATE = "hsl(%s,%s%%,%s%%)";

    public static boolean isAccueilSite(FicheUniv ficheUniv) {
        String codeRubriquePageCourante;
        InfosSite siteCourant;
        boolean isAccueil = Boolean.FALSE;
        if (ficheUniv != null && StringUtils.isNotBlank((CharSequence)ficheUniv.getCodeRubrique()) && (siteCourant = FrontUtil.getSiteCodeRubrique(codeRubriquePageCourante = ficheUniv.getCodeRubrique())) != null && !(isAccueil = codeRubriquePageCourante.equals(siteCourant.getCodeRubrique()))) {
            isAccueil = FrontUtil.isAccueilRubriqueLangue(codeRubriquePageCourante, siteCourant.getCodeRubrique());
        }
        return isAccueil;
    }

    private static boolean isAccueilRubriqueLangue(String codeRubriquePageCourante, String codeRubriqueSiteCourant) {
        Boolean isAccueil = Boolean.FALSE;
        List<InfosRubriques> rubriquesLangues = FrontUtil.getListeSousRubriquesDepuisCategorie(CATEGORIE_LANGUE, codeRubriqueSiteCourant);
        for (int i = 0; i < rubriquesLangues.size() && !isAccueil.booleanValue(); ++i) {
            InfosRubriques rubriqueLangue = rubriquesLangues.get(i);
            isAccueil = codeRubriquePageCourante.equals(rubriqueLangue.getCode());
        }
        return isAccueil;
    }

    private static InfosSite getSiteCodeRubrique(String codeRubriquePageCourante) {
        InfosSite siteCourant = Site.determinerSiteRubrique(codeRubriquePageCourante);
        if (siteCourant == null) {
            siteCourant = Site.getSitePrincipal();
        }
        return siteCourant;
    }

    public static boolean isFicheAccueilRubrique(FicheUniv ficheUniv) {
        if (ficheUniv != null && !FrontUtil.isAccueilSite(ficheUniv)) {
            return FrontUtil.isFicheAccueilRubrique(ficheUniv, Rubrique.renvoyerItemRubrique(ficheUniv.getCodeRubrique()));
        }
        return Boolean.FALSE;
    }

    public static boolean isFicheAccueilRubrique(FicheUniv ficheUniv, InfosRubriques rubrique) {
        BeanPageAccueil beanAccueil;
        Boolean isAccueilRubrique = Boolean.FALSE;
        if (ficheUniv != null && rubrique != null && (beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(rubrique)) != null && beanAccueil instanceof FichePageAccueilRubrique.BeanFichePageAccueil) {
            isAccueilRubrique = ficheUniv.getCode().equals(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getCode()) && ficheUniv.getLangue().equals(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getLangue()) && ReferentielObjets.getNomObjet(ficheUniv).equals(((FichePageAccueilRubrique.BeanFichePageAccueil)beanAccueil).getObjet());
        }
        return isAccueilRubrique;
    }

    public static boolean isSaisieFront(String paramSaisieFront, String paramProcessus) {
        return "true".equalsIgnoreCase(paramSaisieFront) || StringUtils.endsWith((CharSequence)paramProcessus, (CharSequence)"_FRONT");
    }

    @Deprecated
    public static Menu getMenuPrincipal() {
        return MenuFrontFactory.getServiceMenuFront().getMenuSiteCourant(NOM_PROPRIETE_MENU_PRINCIPAL);
    }

    @Deprecated
    public static Menu getMenuPiedDePage() {
        return MenuFrontFactory.getServiceMenuFront().getMenuSiteCourant(NOM_PROPRIETE_MENU_PIED_PAGE);
    }

    @Deprecated
    public static Menu getMenuLangue() {
        return MenuFrontFactory.getServiceMenuFront().getMenuLangue(ContexteUtil.getContexteUniv().getInfosSite(), NOM_PROPRIETE_MENU_PRINCIPAL);
    }

    @Deprecated
    public static Menu getMenuSecondaire() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String codeRubriquePageCourante = ctx.getCodeRubriquePageCourante();
        InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubriquePageCourante);
        String proprieteNiveauMenuSecondaire = ctx.getInfosSite().getProprieteComplementaireString(NOM_PROPRIETE_NIVEAU_MENU_SECONDAIRE);
        String codeRubriqueSecondaire = "";
        if (StringUtils.isNotBlank((CharSequence)proprieteNiveauMenuSecondaire)) {
            int niveauMenuSecondaire = Integer.valueOf(proprieteNiveauMenuSecondaire);
            while (rubriqueCourante.getNiveau() > niveauMenuSecondaire) {
                rubriqueCourante = Rubrique.renvoyerItemRubrique(rubriqueCourante.getCodeRubriqueMere());
            }
            if (rubriqueCourante.getNiveau() == niveauMenuSecondaire) {
                codeRubriqueSecondaire = rubriqueCourante.getCode();
            }
        }
        return MenuFrontFactory.getServiceMenuFront().getMenuParCodeRubrique(codeRubriqueSecondaire);
    }

    public static boolean isMenuCourant(Menu menuAVerifier, String codeRubriqueCourante) {
        boolean isSousRubrique = Boolean.FALSE;
        if (StringUtils.isNotBlank((CharSequence)menuAVerifier.getCodeRubriqueOrigine()) && StringUtils.isNotBlank((CharSequence)codeRubriqueCourante)) {
            InfosRubriques rubriqueParente = Rubrique.renvoyerItemRubrique(menuAVerifier.getCodeRubriqueOrigine());
            InfosRubriques sousRubrique = Rubrique.renvoyerItemRubrique(codeRubriqueCourante);
            isSousRubrique = rubriqueParente.contains(sousRubrique);
        }
        return isSousRubrique;
    }

    public static boolean hasActiveChild(Menu menuAVerifier) {
        for (Menu elementSousMenu : menuAVerifier.getSousMenu()) {
            if (!elementSousMenu.isMenuCourant()) continue;
            return true;
        }
        return false;
    }

    public static Collection<LigneContenu> getLignesFicheCourante(FicheUniv fiche) {
        Collection<LigneContenu> ligneFicheCourante = new ArrayList<LigneContenu>();
        String contenu = "";
        try {
            if (fiche != null) {
                contenu = (String)PropertyUtils.getProperty((Object)fiche, (String)"contenu");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("pas de propri\u00e9t\u00e9 contenu sur cette fiche");
        }
        if (StringUtils.isNotBlank((CharSequence)contenu) && StringUtils.contains((CharSequence)contenu, (CharSequence)"[paragraphe")) {
            ligneFicheCourante = ParagrapheContenuHelper.getLignes(contenu);
        }
        return ligneFicheCourante;
    }

    public static Collection<ParagrapheBean> getParagrapheDepuisFicheCourante(FicheUniv fiche) {
        ArrayList<ParagrapheBean> paragraphe = new ArrayList<ParagrapheBean>();
        Collection<LigneContenu> lignes = FrontUtil.getLignesFicheCourante(fiche);
        for (LigneContenu ligne : lignes) {
            paragraphe.addAll(ligne.getParagraphes());
        }
        return paragraphe;
    }

    @Deprecated
    public static ArrayList<InfosRubriques> calculerRubriquesPageCourante(ContexteUniv ctx, FicheUniv ficheUniv, int sizeListe) {
        return FrontUtil.calculerRubriquesPageCourante(ctx, sizeListe);
    }

    public static ArrayList<InfosRubriques> calculerRubriquesPageCourante(ContexteUniv ctx, int sizeListe) {
        int i;
        InfosRubriques rubriqueCourante;
        ArrayList<InfosRubriques> listeRubriques = new ArrayList<InfosRubriques>(sizeListe);
        String codeRubriqueCourante = ctx.getCodeRubriquePageCourante();
        InfosRubriques rubriqueTemp = rubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubriqueCourante);
        int niveauRubriqueCourante = rubriqueCourante.getNiveau();
        for (i = 0; i < sizeListe; ++i) {
            listeRubriques.add(null);
        }
        if (niveauRubriqueCourante > 0) {
            while (niveauRubriqueCourante > sizeListe) {
                if ((rubriqueTemp = rubriqueTemp != null ? rubriqueTemp.getRubriqueMere() : null) == null) continue;
                niveauRubriqueCourante = rubriqueTemp.getNiveau();
            }
            for (i = niveauRubriqueCourante - 2; i >= 0; --i) {
                rubriqueTemp = rubriqueTemp != null ? rubriqueTemp.getRubriqueMere() : null;
                listeRubriques.set(i, rubriqueTemp);
            }
            listeRubriques.set(niveauRubriqueCourante - 1, rubriqueCourante);
        }
        return listeRubriques;
    }

    public static String getUrlBandeauCourant(ContexteUniv ctx) {
        String urlBandeau = "";
        for (InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique(ctx.getCodeRubriquePageCourante()); rubriqueCourante != null && StringUtils.isNotBlank((CharSequence)rubriqueCourante.getCode()); rubriqueCourante = rubriqueCourante.getRubriqueMere()) {
            if (!StringUtils.isNotBlank((CharSequence)rubriqueCourante.getUrlBandeau())) continue;
            urlBandeau = rubriqueCourante.getUrlBandeau();
            break;
        }
        return urlBandeau;
    }

    public static String calculerListeFichiersJoints(ContexteUniv ctx, FicheUniv ficheUniv) {
        String res = FrontUtil.calculerContenuListeFichiersJoints(ctx, ficheUniv);
        if (res.length() > 0) {
            res = "<ul id=\"telecharger\">" + res + "</ul>";
        }
        return res;
    }

    public static String calculerContenuListeFichiersJoints(ContexteUniv ctx, FicheUniv ficheUniv) {
        List<Ressource> fichiers;
        StringBuilder res = new StringBuilder();
        try {
            fichiers = Ressource.getListeFichier(ficheUniv);
        }
        catch (Exception e) {
            LOG.error("impossible de r\u00e9cup\u00e9rer la liste des fichiers", (Throwable)e);
            fichiers = Collections.emptyList();
        }
        String classeFichierDefaut = "defaut";
        for (Ressource fichier : fichiers) {
            String classeFichier = ClasseFichier.getInstance().containsKey(fichier.getFormat()) ? ClasseFichier.getInstance().get(fichier.getFormat()) : "defaut";
            res.append("<li class=\"").append(classeFichier).append("\">");
            res.append("<a href=\"").append(URLResolver.getRessourceUrl(fichier.getUrl(), ctx)).append("\">");
            if (fichier.getTitre().length() > 0) {
                res.append(fichier.getTitre());
            } else {
                res.append(fichier.getSource());
            }
            res.append("</a> ");
            res.append("<span class='extension-poids-fichiers'> (");
            if (fichier.isLocal() && fichier.getExtension().length() > 0) {
                res.append(fichier.getExtension().toUpperCase());
            } else if (classeFichier.equals("defaut")) {
                res.append(MessageHelper.getCoreMessage("ST_EXTENSION_AUTRE"));
            } else {
                res.append(classeFichier.toUpperCase());
            }
            if (fichier.getPoids() > 0) {
                res.append(", ").append(fichier.getPoids()).append(" ").append(MessageHelper.getCoreMessage("ST_KILO_OCTETS"));
            }
            res.append(")</span>");
            res.append("</li>");
        }
        return res.toString();
    }

    public static String getTitrePageCourante(InfoBean infoBean) {
        return AdminsiteUtils.getTitrePageCourante(infoBean);
    }

    public static boolean isAffichageVisuelRubrique(FicheUniv ficheUniv, String visuelRubrique) {
        boolean affichageVisuel;
        ArrayList<InfosRubriques> rubriquesPageCourante = FrontUtil.calculerRubriquesPageCourante(ContexteUtil.getContexteUniv(), 2);
        InfosRubriques rubriqueNiveau1 = (InfosRubriques)rubriquesPageCourante.get(1);
        boolean bl = affichageVisuel = ficheUniv != null;
        if (affichageVisuel) {
            affichageVisuel = !FrontUtil.isAccueilSite(ficheUniv) && StringUtils.isNotBlank((CharSequence)visuelRubrique) && rubriqueNiveau1 != null && ficheUniv.getCode().equals(rubriqueNiveau1.getCode());
        }
        return affichageVisuel;
    }

    public static List<Menu> getMenuLangueParCategorie() {
        InfosRubriques rubriqueSite = Rubrique.renvoyerItemRubrique(ContexteUtil.getContexteUniv().getInfosSite().getCodeRubrique());
        if (CATEGORIE_LANGUE.equals(rubriqueSite.getCategorie())) {
            return FrontUtil.getMenuParRubriqueParente(rubriqueSite.getRubriqueMere());
        }
        return FrontUtil.getMenuParRubriqueParente(rubriqueSite);
    }

    public static List<Menu> getMenuReseauxSociauxParCategorie() {
        return FrontUtil.getMenuParRubriqueParente(FrontUtil.getRubriqueDepuisCategorie(CATEGORIE_RESEAUX_SOCIAUX));
    }

    public static List<Menu> getMenuPrincipalParCategorie() {
        return FrontUtil.getMenu(FrontUtil.getRubriqueDepuisCategorie(CATEGORIE_NAVIGATION), 2);
    }

    public static List<Menu> getMenuPiedDePageParCategorie() {
        return FrontUtil.getMenu(FrontUtil.getRubriqueDepuisCategorie(CATEGORIE_PIED_PAGE), 2);
    }

    public static List<Menu> getMenuAccesDirectParCategorie() {
        return FrontUtil.getMenuParRubriqueParente(FrontUtil.getRubriqueDepuisCategorie(CATEGORIE_ACCES_DIRECT));
    }

    public static List<Menu> getMenuPlanSite() {
        return FrontUtil.getMenu(FrontUtil.getRubriqueDepuisCategorie(CATEGORIE_NAVIGATION), 2);
    }

    public static List<Menu> getMenuSecondairePageCourante() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String codeRubriquePageCourante = ctx.getCodeRubriquePageCourante();
        InfosRubriques rubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubriquePageCourante);
        List<Menu> menusPrincipal = FrontUtil.getMenuPrincipalParCategorie();
        InfosRubriques rubriqueParente = null;
        for (Menu itemMenuPrincipal : menusPrincipal) {
            InfosRubriques rubriqueMenuPrincipal = Rubrique.renvoyerItemRubrique(itemMenuPrincipal.getCodeRubriqueOrigine());
            if (!rubriqueMenuPrincipal.getCode().equals(rubriqueCourante.getCode()) && !rubriqueMenuPrincipal.contains(rubriqueCourante)) continue;
            rubriqueParente = rubriqueMenuPrincipal;
            break;
        }
        ArrayList<Menu> menuSecondaire = new ArrayList<Menu>();
        if (rubriqueParente != null) {
            menuSecondaire.addAll(FrontUtil.getMenu(rubriqueParente, 2));
        }
        return menuSecondaire;
    }

    public static List<Menu> getMenuParRubriqueParente(InfosRubriques rubriqueParente) {
        ArrayList<Menu> menusParRubriqueParente = new ArrayList<Menu>();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (rubriqueParente != null && StringUtils.isNotBlank((CharSequence)rubriqueParente.getCode())) {
            for (InfosRubriques rubrique : rubriqueParente.getListeSousRubriquesFront(ctx)) {
                menusParRubriqueParente.add(FrontUtil.getMenuParRubrique(rubrique));
            }
        }
        return menusParRubriqueParente;
    }

    public static List<Menu> getMenu(InfosRubriques rubriqueParente, int profondeur) {
        ArrayList<Menu> menuCourant = new ArrayList<Menu>();
        if (rubriqueParente != null && StringUtils.isNotBlank((CharSequence)rubriqueParente.getCode())) {
            for (InfosRubriques rubrique : rubriqueParente.getListeSousRubriquesFront(ContexteUtil.getContexteUniv())) {
                Menu itemMenuCourant = FrontUtil.getMenuParRubrique(rubrique);
                if (profondeur > 0) {
                    itemMenuCourant.addAllSousMenu(FrontUtil.getMenu(rubrique, profondeur - 1));
                }
                menuCourant.add(itemMenuCourant);
            }
        }
        return menuCourant;
    }

    public static Menu getMenuParRubrique(InfosRubriques rubrique) {
        Menu menuRubriqueCourante = new Menu();
        if (rubrique != null && StringUtils.isNotBlank((CharSequence)rubrique.getCode())) {
            menuRubriqueCourante.setCode(rubrique.getCode());
            menuRubriqueCourante.setCodeRubriqueOrigine(rubrique.getCode());
            menuRubriqueCourante.setLibelle(rubrique.getIntitule());
            menuRubriqueCourante.setLangue(rubrique.getLangue());
            menuRubriqueCourante.setType(rubrique.getTypeRubrique());
            menuRubriqueCourante.setVisuel(rubrique.getUrlBandeau());
            menuRubriqueCourante.setPicto(rubrique.getUrlPicto());
            menuRubriqueCourante.setAccroche(rubrique.getAccroche());
            try {
                ContexteUniv ctx = ContexteUtil.getContexteUniv();
                menuRubriqueCourante.setUrl(UnivWebFmt.renvoyerUrlAccueilRubrique(ctx, rubrique.getCode()));
                menuRubriqueCourante.setMenuCourant(FrontUtil.isMenuCourant(menuRubriqueCourante, ctx.getCodeRubriquePageCourante()));
            }
            catch (Exception e) {
                LOG.error("Pas de page d'accueil pour la rubrique \u00ab " + rubrique.getCode() + " \u00bb.");
                menuRubriqueCourante.setUrl("");
            }
        }
        return menuRubriqueCourante;
    }

    public static InfosRubriques getRubriqueDepuisCategorie(String categorie) {
        List<InfosRubriques> listeRubriques;
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String codeRubriqueSiteLangue = ctx.getInfosSite().getCodeRubrique();
        InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubriqueSiteLangue);
        if (!CATEGORIE_LANGUE.equals(rubrique.getCategorie())) {
            String langueCourante = ctx.getLangue();
            codeRubriqueSiteLangue = FrontUtil.getCodeRubriqueLangueParCodeLangue(codeRubriqueSiteLangue, langueCourante);
        }
        if ((listeRubriques = FrontUtil.getListeSousRubriquesDepuisCategorie(categorie, codeRubriqueSiteLangue)).size() > 0) {
            return listeRubriques.get(0);
        }
        return null;
    }

    public static String getCodeRubriqueLangueParCodeLangue(String codeRubriqueSiteLangue, String langueCourante) {
        List<InfosRubriques> rubriques = FrontUtil.getListeSousRubriquesDepuisCategorie(CATEGORIE_LANGUE, codeRubriqueSiteLangue);
        String codeRubrique = "";
        for (InfosRubriques rubrique : rubriques) {
            if (!langueCourante.equals(rubrique.getLangue())) continue;
            codeRubrique = rubrique.getCode();
        }
        return codeRubrique;
    }

    public static List<InfosRubriques> getListeSousRubriquesDepuisCategorie(String categorie, String codeRubriqueParente) {
        ArrayList<InfosRubriques> rubriques = new ArrayList<InfosRubriques>();
        InfosRubriques rubriqueParente = Rubrique.renvoyerItemRubrique(codeRubriqueParente);
        for (InfosRubriques rubrique : rubriqueParente.getListeSousRubriques()) {
            if (categorie.equals(rubrique.getCategorie())) {
                rubriques.add(rubrique);
                continue;
            }
            rubriques.addAll(FrontUtil.getListeSousRubriquesDepuisCategorie(categorie, rubrique.getCode()));
        }
        return rubriques;
    }

    public static InfosRubriques getRubriqueDepuisCategorieEtRubriqueDeSite(String categorie, String codeRubriqueSiteLangue) {
        InfosRubriques resultat = null;
        if (StringUtils.isNotEmpty((CharSequence)categorie)) {
            InfosRubriques rubriqueSiteLangue = Rubrique.renvoyerItemRubrique(codeRubriqueSiteLangue);
            for (InfosRubriques rubrique : rubriqueSiteLangue.getListeSousRubriques()) {
                if (!categorie.equals(rubrique.getCategorie())) continue;
                resultat = rubrique;
                break;
            }
        }
        return resultat;
    }

    public static String getLogoUrl() {
        try {
            return InfosSiteHelper.getURLRelativeFichierPropertyTemplate(ContexteUtil.getContexteUniv().getInfosSite(), NOM_PROPRIETE_LOGO);
        }
        catch (ErreurDonneeNonTrouve e) {
            return "";
        }
    }

    public static String getBaseline() {
        return ContexteUtil.getContexteUniv().getInfosSite().getProprieteComplementaireString(NOM_PROPRIETE_BASELINE);
    }

    public static String getCouleurPrincipale() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        InfosSite siteCourant = ctx.getInfosSite();
        return siteCourant.getProprieteComplementaireString(NOM_PROPRIETE_COULEUR_PRINCIPALE);
    }

    public static String getCouleurSecondaire() {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        InfosSite siteCourant = ctx.getInfosSite();
        return siteCourant.getProprieteComplementaireString(NOM_PROPRIETE_COULEUR_SECONDAIRE);
    }

    @Deprecated
    public static String getRGBaFromHexa(String colorToTransform, double alpha) {
        if (!FrontUtil.isValidHtmlHexaValue(colorToTransform) || alpha > 1.0) {
            return colorToTransform;
        }
        String hex = StringUtils.removeStart((String)colorToTransform, (String)COLOR_PREFIX);
        int r = Integer.valueOf(hex.substring(0, 2), 16);
        int g = Integer.valueOf(hex.substring(2, 4), 16);
        int b = Integer.valueOf(hex.substring(4, 6), 16);
        return String.format(RGBA_TEMPLATE, r, g, b, alpha);
    }

    @Deprecated
    public static boolean isValidHtmlHexaValue(String colorValue) {
        return StringUtils.isNotBlank((CharSequence)colorValue) && colorValue.matches("^(?:#|)[0-9a-fA-F]{6}$");
    }

    @Deprecated
    public static String getHslFromHexa(String colorToTransform, double lumi) {
        if (!FrontUtil.isValidHtmlHexaValue(colorToTransform)) {
            return colorToTransform;
        }
        String hex = StringUtils.removeStart((String)colorToTransform, (String)COLOR_PREFIX);
        int r = Integer.valueOf(hex.substring(0, 2), 16);
        int g = Integer.valueOf(hex.substring(2, 4), 16);
        int b = Integer.valueOf(hex.substring(4, 6), 16);
        float rp = (float)r / 255.0f;
        float gp = (float)g / 255.0f;
        float bp = (float)b / 255.0f;
        float min = Math.min(rp, Math.min(gp, bp));
        float max = Math.max(rp, Math.max(gp, bp));
        float delta = max - min;
        float h = 0.0f;
        float s = 0.0f;
        float l = 0.0f;
        l = (max + min) / 2.0f;
        if (max == rp) {
            h = 60.0f * ((gp - bp) / delta % 6.0f);
        } else if (max == gp) {
            h = 60.0f * ((bp - rp) / delta + 2.0f);
        } else if (max == bp) {
            h = 60.0f * ((rp - gp) / delta + 4.0f);
        }
        s = delta == 0.0f ? 0.0f : delta / (1.0f - Math.abs(2.0f * l - 1.0f));
        return String.format(HSL_TEMPLATE, Math.round(h), Float.valueOf(s * 100.0f), (double)(l * 100.0f) + lumi);
    }

    public static boolean isAnyNotBlank(CharSequence ... sequences) {
        boolean isAnyNotBlank = Boolean.FALSE;
        if (ArrayUtils.isNotEmpty((Object[])sequences)) {
            for (int i = 0; !isAnyNotBlank && i < sequences.length; ++i) {
                isAnyNotBlank = StringUtils.isNotBlank((CharSequence)sequences[i]);
            }
        }
        return isAnyNotBlank;
    }
}

