/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.ihm.utils.sharing;

import com.kportal.core.config.PropertyHelper;
import com.kportal.ihm.utils.sharing.DefaultSocialNetworkUrl;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.utils.ContexteUniv;
import com.univ.utils.EscapeString;
import com.univ.utils.URLResolver;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class TwitterUrl
extends DefaultSocialNetworkUrl {
    private static final String TWITTER_VIA_PROPERTIES = "twitter.via";
    private static final String TWITTER_MAX_LENGTH_PROPERTIES = "twitter.max.length";
    private static final String TWITTER_URL_WITHOUT_VIA_PROPERTIES = "twitter.url.without.via";
    private static final int MAX_LENGTH_DEFAULT = 50;

    @Override
    public String getSharingUrl(FicheUniv fiche, ContexteUniv ctx) {
        String sharingUrl = "";
        String networkUrl = this.getSocialNetworkUrl();
        String via = StringUtils.defaultString((String)PropertyHelper.getCoreProperty(TWITTER_VIA_PROPERTIES));
        if (StringUtils.isBlank((CharSequence)via)) {
            networkUrl = PropertyHelper.getCoreProperty(TWITTER_URL_WITHOUT_VIA_PROPERTIES);
        }
        if (StringUtils.isNotBlank((CharSequence)networkUrl) && fiche != null) {
            String urlFiche = URLResolver.getAbsoluteUrlFiche(fiche, ctx);
            String maxLength = PropertyHelper.getCoreProperty(TWITTER_MAX_LENGTH_PROPERTIES);
            int max = 50;
            if (StringUtils.isNotBlank((CharSequence)maxLength) && StringUtils.isNumeric((CharSequence)maxLength)) {
                max = Integer.valueOf(maxLength);
            }
            String title = EscapeString.escapeURL(StringUtils.abbreviate((String)fiche.getLibelleAffichable(), (int)max));
            sharingUrl = StringUtils.isNotBlank((CharSequence)via) ? MessageFormat.format(networkUrl, EscapeString.escapeURL(urlFiche), EscapeString.escapeURL(via), title) : MessageFormat.format(networkUrl, EscapeString.escapeURL(urlFiche), title);
        }
        return sharingUrl;
    }
}

