/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.pdf;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.core.config.PropertyHelper;
import com.kportal.pdf.PDFproperties;
import com.kportal.servlet.BufferedHttpResponseWrapper;
import com.univ.utils.Chaine;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.allcolor.yahp.converter.CYaHPConverter;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFFilter
implements Filter {
    private static PDFproperties pdfProperties;
    private static final Logger LOG;

    public void init(FilterConfig filterConfig) throws ServletException {
        pdfProperties = ApplicationContextManager.getEveryContextBean("pdfProperties", PDFproperties.class);
        if (pdfProperties == null) {
            pdfProperties = new PDFproperties();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.isRequestForPdf(request)) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            BufferedHttpResponseWrapper wrapper = new BufferedHttpResponseWrapper(response);
            filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
            if (wrapper.getStatus() == 200) {
                String urlWithoutParameter = request.getRequestURL().toString();
                String title = this.getTitle(urlWithoutParameter);
                response.setHeader("Content-Disposition", this.getContentDispositionHeader(title));
                response.setContentType("application/pdf");
                CYaHPConverter converter = new CYaHPConverter();
                ServletOutputStream os = response.getOutputStream();
                try {
                    this.convert(urlWithoutParameter, wrapper.getOutput(), title, converter, (OutputStream)os);
                }
                catch (IHtmlToPdfTransformer.CConvertException e) {
                    LOG.error("impossible de g\u00e9n\u00e9rer le PDF", (Throwable)e);
                }
                os.flush();
                os.close();
            } else {
                ServletOutputStream os = response.getOutputStream();
                os.write(wrapper.getOutput().getBytes());
                os.flush();
                os.close();
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean isRequestForPdf(HttpServletRequest request) {
        return "true".equals(request.getParameter("toPdf"));
    }

    public void destroy() {
    }

    private void convert(String sUrl, String content, String title, CYaHPConverter converter, OutputStream os) throws IHtmlToPdfTransformer.CConvertException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("yahp.PDF_RENDERER_CLASS", "org.allcolor.yahp.cl.converter.CHtmlToPdfFlyingSaucerTransformer");
        if (pdfProperties.getFontsPath().length() > 0) {
            properties.put("yahp.FOP_TTF_FONT_PATH", pdfProperties.getFontsPath());
        }
        ArrayList<IHtmlToPdfTransformer.CHeaderFooter> headerFooterList = new ArrayList<IHtmlToPdfTransformer.CHeaderFooter>();
        if (pdfProperties.getFooterHtml().length() > 0) {
            headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(this.format(pdfProperties.getFooterHtml(), title, sUrl), "footer"));
        }
        if (pdfProperties.getHeaderHtml().length() > 0) {
            headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(this.format(pdfProperties.getHeaderHtml(), title, sUrl), "header"));
        }
        converter.convertToPdf(Chaine.encodeSpecialEntities(content), pdfProperties.getPageSize(), headerFooterList, sUrl, os, properties);
    }

    private String format(String contenu, String title, String url) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        contenu = StringUtils.replace((String)contenu, (String)"<date>", (String)sdf.format(new Date(System.currentTimeMillis())));
        contenu = StringUtils.replace((String)contenu, (String)"<url>", (String)url);
        contenu = StringUtils.replace((String)contenu, (String)"<title>", (String)title);
        return contenu;
    }

    private String getTitle(String url) {
        String title = "";
        if (StringUtils.endsWith((CharSequence)url, (CharSequence)"/")) {
            title = StringUtils.substringAfterLast((String)url.substring(0, url.length() - 1), (String)"/");
        } else {
            title = StringUtils.substringAfterLast((String)url, (String)"/");
            title = StringUtils.substringBeforeLast((String)title, (String)"-");
        }
        return title;
    }

    private String getContentDispositionHeader(String title) {
        String typeDisposition = PropertyHelper.getCoreProperty("telechargement.disposition");
        String contentDisposition = "attachment;filename=\"" + title + ".pdf\"";
        if ("inline".equals(typeDisposition)) {
            contentDisposition = "inline;filename=\"" + title + ".pdf\"";
        }
        return contentDisposition;
    }

    public String getUrlFromRequest() {
        return null;
    }

    static {
        LOG = LoggerFactory.getLogger(PDFFilter.class);
    }
}

