/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.rubrique.util;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriqueManager {
    private static final Logger LOG = LoggerFactory.getLogger(RubriqueManager.class);

    public static void deleteRubrique(OMContext ctx, InfosRubriques infosRubriques, boolean deleteContent, boolean recursif) throws Exception {
        Collection<InfosRubriques> lstSousRubriques;
        if (infosRubriques == null) {
            return;
        }
        LOG.info("Requ\u00eate rubrique : code=" + infosRubriques.getCode() + " libelle=" + infosRubriques.getIntitule());
        if (deleteContent && infosRubriques.getCode() != null) {
            Metatag meta = new Metatag();
            meta.setCtx(ctx);
            meta.init();
            ClauseWhere where = new ClauseWhere();
            where.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_RUBRIQUE", infosRubriques.getCode()));
            if (meta.select(where.formaterSQL()) > 0) {
                while (meta.nextItem()) {
                    FicheUniv ficheUniv = FicheUnivMgr.init(meta);
                    ficheUniv.setCtx(ctx);
                    ficheUniv.setIdFiche(meta.getMetaIdFiche());
                    try {
                        ficheUniv.retrieve();
                        FicheUnivMgr.supprimerFiche(ficheUniv, true);
                        LOG.info("Suppression fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
                    }
                    catch (Exception e) {
                        LOG.info("Erreur suppression fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
                    }
                }
            }
        }
        if (recursif && (lstSousRubriques = infosRubriques.getListeSousRubriques()).size() > 0) {
            for (InfosRubriques infosSousRubriques : lstSousRubriques) {
                RubriqueManager.deleteRubrique(ctx, infosSousRubriques, deleteContent, recursif);
            }
        }
        Rubrique rubrique = new Rubrique();
        rubrique.setCtx(ctx);
        rubrique.init();
        rubrique.setIdRubrique(infosRubriques.getIdRubrique());
        rubrique.retrieve();
        rubrique.delete();
        LOG.info("Suppression rubrique : code=" + infosRubriques.getCode() + " libelle=" + infosRubriques.getIntitule());
    }

    public static void changeRedacteur(OMContext ctx, InfosRubriques infosRubriques, String oldCode, String newCode, boolean recursif) throws Exception {
        Collection<InfosRubriques> lstSousRubriques;
        if (infosRubriques == null || infosRubriques.getCode() == null || oldCode == null || newCode == null) {
            LOG.info("Changement de redacteur impossible avec ces parametres : oldcode = " + oldCode + " newCode = " + newCode + " infosRubriques " + infosRubriques);
            return;
        }
        LOG.info("Requ\u00eate rubrique : code=" + infosRubriques.getCode() + " libelle=" + infosRubriques.getIntitule());
        Metatag meta = new Metatag();
        meta.setCtx(ctx);
        meta.init();
        ClauseWhere where = new ClauseWhere();
        where.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_RUBRIQUE", infosRubriques.getCode()));
        where.and(ConditionHelper.egalVarchar("META_CODE_REDACTEUR", oldCode));
        if (meta.select(where.formaterSQL()) > 0) {
            while (meta.nextItem()) {
                FicheUniv ficheUniv = FicheUnivMgr.init(meta);
                ficheUniv.setCtx(ctx);
                ficheUniv.setIdFiche(meta.getMetaIdFiche());
                try {
                    ficheUniv.retrieve();
                    ficheUniv.setCodeRedacteur(newCode);
                    ficheUniv.setCodeValidation(newCode);
                    ficheUniv.update();
                    LOG.info("Mise \u00e0 jour fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
                }
                catch (Exception e) {
                    LOG.info("Erreur mise \u00e0 jour fiche : type=" + ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()) + " code=" + ficheUniv.getCode() + " libelle=" + ficheUniv.getLibelleAffichable());
                }
            }
        }
        if (recursif && (lstSousRubriques = infosRubriques.getListeSousRubriques()).size() > 0) {
            for (InfosRubriques infosSousRubriques : lstSousRubriques) {
                RubriqueManager.changeRedacteur(ctx, infosSousRubriques, oldCode, newCode, recursif);
            }
        }
    }
}

