/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.rubrique.util;

import com.kportal.rubrique.util.RubriqueProvider;
import com.kportal.rubrique.util.RubriqueWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriqueReader {
    public static Logger logger = LoggerFactory.getLogger(RubriqueReader.class);
    public RubriqueProvider provider = null;

    public RubriqueReader(RubriqueProvider rubriqueProvider) {
        this.provider = rubriqueProvider;
    }

    public RubriqueProvider getProvider() {
        return this.provider;
    }

    public void setProvider(RubriqueProvider provider) {
        this.provider = provider;
    }

    public Map<String, RubriqueWrapper> read(String paths) {
        String path;
        StringTokenizer pathTokenizer;
        logger.info("---> lecture : chemins = " + paths);
        Map<String, RubriqueWrapper> rubriques = null;
        if (this.provider == null) {
            logger.error("- probl\u00e8me de lecture : provider null (extension de fichier non reconnue)");
        } else if (paths != null && !"".equals(paths.trim()) && (pathTokenizer = new StringTokenizer(paths = paths.trim(), ";")).hasMoreElements() && (path = pathTokenizer.nextToken().trim()) != null && !"".equals(path)) {
            block17: {
                logger.info("> parcours du chemin : " + path);
                File file = new File(path);
                if (!file.exists()) {
                    logger.info("- chemin inexistant");
                } else if (!file.canRead()) {
                    logger.info("- pas de droits de lecture sur ce chemin");
                } else if (file.isHidden()) {
                    logger.info("- chemin cach\u00e9 : donn\u00e9es ignor\u00e9es");
                } else if (file.isFile()) {
                    logger.info("- le chemin correspond \u00e0 un fichier");
                    try {
                        rubriques = this.provider.setRubrique(file);
                        if (rubriques == null) {
                            logger.info("- impossible de parser le fichier");
                            break block17;
                        }
                        logger.info("- parsing ok");
                    }
                    catch (FileNotFoundException e) {
                        logger.info("- probl\u00e8me lors de la lecture du fichier (fichier non trouv\u00e9) : " + e.getMessage());
                    }
                    catch (Exception e) {
                        logger.info("- probl\u00e8me lors de la lecture du fichier :" + e.getMessage());
                    }
                } else if (file.isDirectory()) {
                    logger.info("- le chemin correspond \u00e0 un r\u00e9pertoire : on ne fait rien");
                } else {
                    logger.info("- chemin de type inconnu");
                }
            }
            logger.info("< chemin parcouru : " + path);
        }
        logger.info("<--- fin de lecture : " + (rubriques == null ? "0" : Integer.valueOf(rubriques.size())) + " rubriques trait\u00e9es");
        return rubriques;
    }
}

