/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.rubrique.util;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.BasicPoolMgr;
import com.kportal.rubrique.util.RubriqueImporter;
import com.kportal.rubrique.util.RubriqueWrapper;
import com.univ.objetspartages.om.PageLibre;
import com.univ.objetspartages.om.Rubrique;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLRubriqueImporter
extends RubriqueImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLRubriqueImporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubriqueWrapper getOriginalWrapper(String code, String langue) throws Exception {
        Rubrique rubrique = new Rubrique();
        rubrique.init();
        RubriqueWrapper wrapper = new RubriqueWrapper(rubrique);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String query = "select * from RUBRIQUE where CODE = ? and LANGUE = ?";
            connection = BasicPoolMgr.getConnection(true);
            stmt = connection.prepareStatement(query);
            stmt.setObject(1, (Object)code, 12);
            stmt.setObject(2, (Object)langue, 12);
            LOGGER.info("SQL Query = " + query);
            rs = stmt.executeQuery();
            if (rs.next()) {
                wrapper.setIdRubrique(Long.valueOf(rs.getString("ID_RUBRIQUE")));
                wrapper.setCode(rs.getString("CODE"));
                wrapper.setLangue(rs.getString("LANGUE"));
                wrapper.setCodeRubriqueMere(rs.getString("CODE_RUBRIQUE_MERE"));
                wrapper.setIntitule(rs.getString("INTITULE"));
                wrapper.setNomOnglet(rs.getString("NOM_ONGLET"));
                wrapper.setIntitule(rs.getString("INTITULE"));
                wrapper.setOrdre(rs.getString("ORDRE"));
                wrapper.setTypeRubrique(rs.getString("TYPE_RUBRIQUE"));
                wrapper.setPageAccueil(rs.getString("PAGE_ACCUEIL"));
                wrapper.setCategorie(rs.getString("CATEGORIE"));
            }
        }
        finally {
            block42: {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        if (stmt == null) break block42;
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException2) {
                        }
                        finally {
                            BasicPoolMgr.releaseConnection(connection);
                        }
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                BasicPoolMgr.releaseConnection(connection);
                            }
                        }
                    }
                }
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyExists(String code, String langue) throws Exception {
        boolean alreadyExists = false;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String query = "select ID_RUBRIQUE from RUBRIQUE where CODE = ? and LANGUE = ?";
            connection = BasicPoolMgr.getConnection(true);
            stmt = connection.prepareStatement(query);
            stmt.setObject(1, (Object)code, 12);
            stmt.setObject(2, (Object)langue, 12);
            LOGGER.info("SQL Query = " + query);
            rs = stmt.executeQuery();
            if (rs.next()) {
                alreadyExists = true;
            }
        }
        finally {
            block42: {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        if (stmt == null) break block42;
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException2) {
                        }
                        finally {
                            BasicPoolMgr.releaseConnection(connection);
                        }
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                BasicPoolMgr.releaseConnection(connection);
                            }
                        }
                    }
                }
            }
        }
        return alreadyExists;
    }

    private boolean prepareWrapper(Map<String, RubriqueWrapper> rubriques, RubriqueWrapper wrapperSRC, RubriqueWrapper wrapperDST) throws Exception {
        boolean ok = true;
        if (wrapperSRC.getCode() == null || "".equals(wrapperSRC.getCode().trim())) {
            if (wrapperSRC == wrapperDST) {
                LOGGER.info("- nouvelle rubrique sans code g\u00e9n\u00e9r\u00e9 : skip");
                ok = false;
            } else {
                LOGGER.info("- rubrique sans code g\u00e9n\u00e9r\u00e9 : deprecated value");
            }
        }
        if (wrapperSRC.getLangue() == null || LangueUtil.getLocale(wrapperSRC.getLangue()) == null) {
            if (wrapperSRC == wrapperDST) {
                LOGGER.info("- langue introuvable : set default one");
                wrapperDST.setLangue(String.valueOf(LangueUtil.getIndiceLocale(LangueUtil.getDefaultLocale())));
            } else {
                LOGGER.info("- langue introuvable : ignored value change");
            }
        } else {
            wrapperDST.setLangue(wrapperSRC.getLangue());
        }
        if (wrapperSRC.getOrdre() == null || "".equals(wrapperSRC.getOrdre().trim()) || !wrapperSRC.getOrdre().matches("^[0-9]+$")) {
            if (wrapperSRC == wrapperDST) {
                LOGGER.info("- ordre invalide : set 0");
                wrapperDST.setOrdre("0");
            } else {
                LOGGER.info("- ordre invalide : ignored value change");
            }
        } else {
            wrapperDST.setOrdre(wrapperSRC.getLangue());
        }
        if (wrapperSRC.getIntitule() == null || "".equals(wrapperSRC.getIntitule().trim())) {
            if (wrapperSRC == wrapperDST) {
                LOGGER.info("- intitul\u00e9 absent : deprecated value");
            } else {
                LOGGER.info("- intitul\u00e9 absent : ignored value change");
            }
        } else {
            wrapperDST.setIntitule(wrapperSRC.getIntitule());
        }
        if (wrapperSRC.getNomOnglet() == null || "".equals(wrapperSRC.getNomOnglet().trim())) {
            if (wrapperSRC == wrapperDST) {
                LOGGER.info("- nom d'onglet absent : set INTITULE");
                wrapperDST.setNomOnglet(wrapperDST.getIntitule());
            } else {
                LOGGER.info("- nom d'onglet absent : ignored value change");
            }
        } else {
            wrapperDST.setNomOnglet(wrapperSRC.getNomOnglet());
        }
        if (wrapperDST.getNomOnglet() != null) {
            wrapperDST.setNomOnglet(wrapperDST.getNomOnglet().substring(0, Math.min(wrapperDST.getNomOnglet().length(), 32)));
        }
        if (!wrapperSRC.isRoot()) {
            boolean parentAlreadyExists = this.alreadyExists(wrapperSRC.getCodeRubriqueMere(), wrapperSRC.getLangue());
            if (!parentAlreadyExists && !rubriques.containsKey(wrapperSRC.getCodeRubriqueMere())) {
                LOGGER.info("- rubrique m\u00e8re introuvable : set root");
                wrapperDST.setCodeRubriqueMere("");
            } else {
                wrapperDST.setCodeRubriqueMere(wrapperSRC.getCodeRubriqueMere());
            }
        } else {
            wrapperDST.setCodeRubriqueMere("");
        }
        if (wrapperSRC.getCategorie() == null || "".equals(wrapperSRC.getCategorie().trim())) {
            if (wrapperSRC == wrapperDST) {
                LOGGER.info("- cat\u00e9gorie absente : no problem");
            } else {
                LOGGER.info("- cat\u00e9gorie absente : ignored value change");
            }
        } else {
            wrapperDST.setCategorie(wrapperSRC.getCategorie());
        }
        if (wrapperSRC == wrapperDST) {
            if (wrapperSRC.getGenererPageTete() != null && "1".equals(wrapperSRC.getGenererPageTete().trim())) {
                wrapperDST.setTypeRubrique("0001");
                wrapperDST.setPageAccueil("{\"code\":\"?\",\"langue\":\"" + wrapperSRC.getLangue() + "\",\"objet\":\"pagelibre\"}\"");
            } else {
                wrapperDST.setGenererPageTete("0");
                if (wrapperSRC.getPageAccueil() != null && !"".equals(wrapperSRC.getPageAccueil().trim())) {
                    wrapperDST.setTypeRubrique(wrapperSRC.getTypeRubrique());
                    wrapperDST.setPageAccueil(wrapperSRC.getPageAccueil());
                } else {
                    LOGGER.info("- aucune d\u00e9finition de CODE_PAGE_TETE : no checking");
                    if (wrapperSRC == wrapperDST) {
                        wrapperDST.setTypeRubrique(wrapperSRC.getTypeRubrique());
                        wrapperDST.setPageAccueil("");
                    } else {
                        LOGGER.info("- type et code : ignored value change");
                    }
                }
            }
        } else {
            LOGGER.info("- rubrique existante : g\u00e9n\u00e9ration de la page d'ent\u00eate ignor\u00e9e");
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean importWrappers(Map<String, RubriqueWrapper> rubriques) {
        XMLRubriqueImporter.LOGGER.info("---> import rubriques start");
        importOK = true;
        pageCodeGeneration = 0L;
        if (rubriques != null && !rubriques.isEmpty()) {
            iRubrique = rubriques.values().iterator();
            connection = null;
            try {
                connection = BasicPoolMgr.getConnection(true);
                connection.setAutoCommit(false);
                while (iRubrique.hasNext()) {
                    wrapper = iRubrique.next();
                    if (wrapper == null) continue;
                    XMLRubriqueImporter.LOGGER.info("-> start import rubrique : " + wrapper.getCode());
                    if (!this.prepareWrapper(rubriques, wrapper, wrapper)) continue;
                    alreadyExists = this.alreadyExists(wrapper.getCode(), wrapper.getLangue());
                    if (alreadyExists) {
                        XMLRubriqueImporter.LOGGER.info("- la rubrique existe d\u00e9j\u00e0");
                    } else {
                        XMLRubriqueImporter.LOGGER.info("- nouvelle rubrique");
                    }
                    if (alreadyExists) {
                        if (!this.isSynchrone()) {
                            XMLRubriqueImporter.LOGGER.info("- importation sans synchronisation : rubrique skip");
                            continue;
                        }
                        XMLRubriqueImporter.LOGGER.info("- importation avec synchronisation : rubrique will be scratched");
                        wrapperDST = this.getOriginalWrapper(wrapper.getCode(), wrapper.getLangue());
                        if (!this.prepareWrapper(rubriques, wrapper, wrapperDST)) continue;
                        wrapper = wrapperDST;
                    }
                    stmt = null;
                    try {
                        query = "";
                        if (wrapper.getGenererPageTete() != null && "1".equals(wrapper.getGenererPageTete().trim())) {
                            XMLRubriqueImporter.LOGGER.info("- g\u00e9n\u00e9ration \u00e0 la vol\u00e9e d'une page libre pour la rubrique");
                            page = new PageLibre();
                            page.init();
                            if (pageCodeGeneration == 0L) {
                                pageCodeGeneration = Long.parseLong(page.getCode());
                            } else {
                                page.setCode(String.valueOf(++pageCodeGeneration));
                            }
                            page.setLangue(wrapper.getLangue());
                            page.setTitre(wrapper.getIntitule());
                            page.setCodeRubrique(wrapper.getCode());
                            query = "insert into PAGELIBRE(CODE, LANGUE, ETAT_OBJET, CODE_RUBRIQUE, TITRE, CONTENU, COMPLEMENTS, META_KEYWORDS, META_DESCRIPTION, CONTENU_ENCADRE, MESSAGE_ALERTE, NB_HITS) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            stmt = connection.prepareStatement(query);
                            stmt.setObject(1, page.getCode(), 12);
                            stmt.setObject(2, page.getLangue(), 12);
                            stmt.setObject(3, "0003", 12);
                            stmt.setObject(4, page.getCodeRubrique(), 12);
                            stmt.setObject(5, page.getTitre(), 12);
                            stmt.setObject(6, page.getContenu(), 12);
                            stmt.setObject(7, page.getComplements(), 12);
                            stmt.setObject(8, page.getMetaKeywords(), 12);
                            stmt.setObject(9, page.getMetaDescription(), 12);
                            stmt.setObject(10, page.getContenuEncadre(), 12);
                            stmt.setObject(11, page.getMessageAlerte(), 12);
                            stmt.setObject(12, page.getNbHits(), -5);
                            XMLRubriqueImporter.LOGGER.info("- SQL Query = " + query);
                            stmt.executeUpdate();
                            wrapper.setPageAccueil(wrapper.getPageAccueil());
                        }
                        XMLRubriqueImporter.LOGGER.info("- insertion / maj de la rubrique");
                        if (alreadyExists) {
                            query = "update RUBRIQUE set INTITULE = ?, NOM_ONGLET = ?, ORDRE = ?, CODE_RUBRIQUE_MERE = ?, CATEGORIE = ? where ID_RUBRIQUE = ?";
                            stmt = connection.prepareStatement(query);
                            stmt.setObject(1, wrapper.getIntitule(), 12);
                            stmt.setObject(2, wrapper.getNomOnglet(), 12);
                            stmt.setObject(3, wrapper.getOrdre(), 12);
                            stmt.setObject(4, wrapper.getCodeRubriqueMere(), 12);
                            stmt.setObject(5, wrapper.getCategorie(), 12);
                            stmt.setObject(6, wrapper.getIdRubrique(), -5);
                        } else {
                            query = "insert into RUBRIQUE(CODE, LANGUE, INTITULE, NOM_ONGLET, ORDRE, TYPE_RUBRIQUE, PAGE_ACCUEIL, CODE_RUBRIQUE_MERE, CATEGORIE, ACCROCHE, ID_BANDEAU, ENCADRE, GROUPES_DSI, REQUETES_RUBRIQUE_PUBLICATION) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            stmt = connection.prepareStatement(query);
                            stmt.setObject(1, wrapper.getCode(), 12);
                            stmt.setObject(2, wrapper.getLangue(), 12);
                            stmt.setObject(3, wrapper.getIntitule(), 12);
                            stmt.setObject(4, wrapper.getNomOnglet(), 12);
                            stmt.setObject(5, wrapper.getOrdre(), 12);
                            stmt.setObject(6, wrapper.getTypeRubrique(), 12);
                            stmt.setObject(7, wrapper.getPageAccueil(), 12);
                            stmt.setObject(8, wrapper.getCodeRubriqueMere(), 12);
                            stmt.setObject(9, wrapper.getCategorie(), 12);
                            stmt.setObject(10, wrapper.getAccroche(), 12);
                            stmt.setObject(11, wrapper.getIdBandeau(), -5);
                            stmt.setObject(12, wrapper.getEncadre(), 12);
                            stmt.setObject(13, wrapper.getGroupesDsi(), 12);
                            stmt.setObject(14, wrapper.getRequetesRubriquePublication(), 12);
                        }
                        XMLRubriqueImporter.LOGGER.info("- SQL Query = " + query);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException var10_12) {}
                        }
                    }
                    XMLRubriqueImporter.LOGGER.info("<- end import rubrique : " + wrapper.getCode());
                }
                connection.commit();
            }
            catch (Exception e) {
                importOK = false;
                XMLRubriqueImporter.LOGGER.info("- exception caught : all imports canceled");
                if (XMLRubriqueImporter.LOGGER.isDebugEnabled()) {
                    XMLRubriqueImporter.LOGGER.debug("exception pendant l'import", (Throwable)e);
                }
                try {
                    if (connection == null || connection.getAutoCommit()) ** GOTO lbl121
                    connection.rollback();
                }
                catch (Exception var8_9) {
                    // empty catch block
                }
            }
            finally {
                if (connection != null) {
                    BasicPoolMgr.releaseConnection(connection);
                }
            }
        } else {
            XMLRubriqueImporter.LOGGER.info("- no rubriques to import");
        }
lbl121:
        // 5 sources

        XMLRubriqueImporter.LOGGER.info("<--- import rubriques end");
        return importOK;
    }
}

