/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.rubrique.util;

import com.kportal.rubrique.util.RubriqueProvider;
import com.kportal.rubrique.util.RubriqueWrapper;
import com.univ.objetspartages.om.Rubrique;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLRubriqueProvider
extends RubriqueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLRubriqueProvider.class);
    public static final String XML_MIME_TYPE_PATTERN = "^(.*,)?application/xml(,.*)?$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RubriqueWrapper> setRubrique(File file) throws FileNotFoundException {
        HashMap<String, RubriqueWrapper> wrappers = null;
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            LOGGER.info("parsing xml document");
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            if (doc != null) {
                NodeList items = doc.getElementsByTagName("ITEM");
                if (items != null && items.getLength() > 0) {
                    wrappers = new HashMap<String, RubriqueWrapper>();
                    for (int i = 0; i < items.getLength(); ++i) {
                        NodeList itemHeadProperties;
                        NodeList itemHeadAndData;
                        Node item = items.item(i);
                        if (item == null || (itemHeadAndData = item.getChildNodes()) == null) continue;
                        Node itemHead = null;
                        Element itemData = null;
                        for (int j = 0; j < itemHeadAndData.getLength(); ++j) {
                            if (itemHeadAndData.item(j).getNodeType() == 1 && "ENTETE".equals(((Element)itemHeadAndData.item(j)).getTagName())) {
                                itemHead = (Element)itemHeadAndData.item(j);
                                continue;
                            }
                            if (itemHeadAndData.item(j).getNodeType() != 1 || !"DONNEES".equals(((Element)itemHeadAndData.item(j)).getTagName())) continue;
                            itemData = (Element)itemHeadAndData.item(j);
                        }
                        String objectProperty = null;
                        String actionProperty = null;
                        String codeProperty = null;
                        String langueProperty = null;
                        if (itemHead != null && (itemHeadProperties = itemHead.getChildNodes()) != null) {
                            for (int j = 0; j < itemHeadProperties.getLength(); ++j) {
                                if (itemHeadProperties.item(j).getNodeType() == 1 && "OBJET".equals(((Element)itemHeadProperties.item(j)).getTagName())) {
                                    objectProperty = ((Element)itemHeadProperties.item(j)).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (itemHeadProperties.item(j).getNodeType() == 1 && "ACTION".equals(((Element)itemHeadProperties.item(j)).getTagName())) {
                                    actionProperty = ((Element)itemHeadProperties.item(j)).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (itemHeadProperties.item(j).getNodeType() == 1 && "CODE".equals(((Element)itemHeadProperties.item(j)).getTagName())) {
                                    codeProperty = ((Element)itemHeadProperties.item(j)).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (itemHeadProperties.item(j).getNodeType() != 1 || !"LANGUE".equals(((Element)itemHeadProperties.item(j)).getTagName())) continue;
                                langueProperty = ((Element)itemHeadProperties.item(j)).getFirstChild().getNodeValue();
                            }
                        }
                        if (objectProperty == null || !"RUBRIQUE".equals(objectProperty.toUpperCase())) continue;
                        LOGGER.info("rubrique found : processing");
                        Rubrique rubrique = new Rubrique();
                        rubrique.init();
                        RubriqueWrapper wrapper = new RubriqueWrapper(rubrique);
                        if (codeProperty != null) {
                            wrapper.setCode(codeProperty);
                        }
                        if (langueProperty != null) {
                            wrapper.setLangue(langueProperty);
                        }
                        if (actionProperty != null) {
                            wrapper.setAction(actionProperty);
                        }
                        NodeList itemDatasProperties = null;
                        if (itemData != null) {
                            itemDatasProperties = itemData.getChildNodes();
                        }
                        if (itemDatasProperties != null && itemDatasProperties.getLength() > 0) {
                            for (int j = 0; j < itemDatasProperties.getLength(); ++j) {
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "CODE_RUBRIQUE_MERE".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setCodeRubriqueMere(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "INTITULE".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setIntitule(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "NOM_ONGLET".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setNomOnglet(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "ORDRE".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setOrdre(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "TYPE_RUBRIQUE".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setTypeRubrique(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "PAGE_ACCUEIL".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setPageAccueil(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() == 1 && "GENERER_PAGE_TETE".equals(((Element)itemDatasProperties.item(j)).getTagName()) && itemDatasProperties.item(j).getFirstChild() != null) {
                                    wrapper.setGenererPageTete(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (itemDatasProperties.item(j).getNodeType() != 1 || !"CATEGORIE".equals(((Element)itemDatasProperties.item(j)).getTagName()) || itemDatasProperties.item(j).getFirstChild() == null) continue;
                                wrapper.setCategorie(((Element)itemDatasProperties.item(j)).getFirstChild().getNodeValue());
                            }
                            if (wrapper.getCode() != null && !wrapper.getCode().trim().equals("")) {
                                if (!wrappers.containsKey(wrapper.getCode())) {
                                    wrappers.put(wrapper.getCode(), wrapper);
                                    LOGGER.info("rubrique inserted : " + wrapper.getCode());
                                    if (wrapper.getCodeRubriqueMere() == null || wrapper.getCodeRubriqueMere().trim().equals("")) continue;
                                    if (wrappers.containsKey(wrapper.getCodeRubriqueMere())) {
                                        ((RubriqueWrapper)wrappers.get(wrapper.getCodeRubriqueMere().trim())).getSousRubriques().add(wrapper);
                                        LOGGER.info("rubrique defined as child of mother rubrique " + wrapper.getCodeRubriqueMere().trim());
                                        continue;
                                    }
                                    wrapper.setCodeRubriqueMere("");
                                    LOGGER.info("rubrique defined as child of mother rubrique [" + wrapper.getCodeRubriqueMere().trim() + "] but no match : set this rubrique as root");
                                    continue;
                                }
                                LOGGER.info("rubrique already found : ignore this occurence");
                                continue;
                            }
                            LOGGER.info("rubrique without CODE (if it is a new one set an arbitrary value) : ignored");
                            continue;
                        }
                        LOGGER.info("rubrique without any data : skip");
                    }
                } else {
                    LOGGER.info("no rubriques found");
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exception pendant l'import", (Throwable)e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return wrappers;
    }
}

