/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.module;

import com.kportal.extension.module.AbstractBeanManager;
import com.kportal.extension.module.IModule;
import com.kportal.scheduling.module.IJobModule;
import com.kportal.scheduling.module.SchedulerManagerHelper;
import com.kportal.scheduling.monitoring.impl.quartz.BatchExecutionDateHelper;
import com.kportal.scheduling.monitoring.impl.quartz.BatchExecutionEndHelper;
import com.kportal.scheduling.service.SequenceTrigger;
import com.kportal.scheduling.service.SequenceTriggerFactory;
import com.kportal.scheduling.spring.quartz.SequenceJob;
import java.util.HashMap;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerManager
extends AbstractBeanManager {
    public static final String ID_BEAN = "schedulerManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerManager.class);
    private Scheduler scheduler;
    private SequenceTriggerFactory triggerFactory;
    private TriggerListener triggerListener;
    private BatchExecutionDateHelper batchExecutionDateHelper;
    private BatchExecutionEndHelper batchExecutionEndHelper;

    public TriggerListener getTriggerListener() {
        return this.triggerListener;
    }

    public void setTriggerListener(TriggerListener triggerListener) {
        this.triggerListener = triggerListener;
    }

    public SequenceTriggerFactory getTriggerFactory() {
        return this.triggerFactory;
    }

    public void setTriggerFactory(SequenceTriggerFactory triggerFactory) {
        this.triggerFactory = triggerFactory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map<JobKey, JobDetail> getJobDetails() {
        HashMap<JobKey, JobDetail> res = new HashMap<JobKey, JobDetail>();
        for (IModule iModule : this.moduleManager.getModules(IJobModule.class)) {
            if (((IJobModule)iModule).getJobDetails().size() <= 0) continue;
            for (JobDetail jobDetail : ((IJobModule)iModule).getJobDetails()) {
                res.put(jobDetail.getKey(), jobDetail);
            }
        }
        return res;
    }

    public Map<String, IJobModule> getJobModules() {
        HashMap<String, IJobModule> res = new HashMap<String, IJobModule>();
        for (IModule iModule : this.moduleManager.getModules(IJobModule.class)) {
            if (((IJobModule)iModule).getJobDetails().size() <= 0) continue;
            for (JobDetail jobDetail : ((IJobModule)iModule).getJobDetails()) {
                res.put(jobDetail.getKey().getName(), (IJobModule)iModule);
            }
        }
        return res;
    }

    public Map<String, SequenceTrigger> getSequenceTriggers() {
        return this.triggerFactory.getSequenceTriggerService().getSequenceTriggers();
    }

    public boolean isJobActif(JobKey jobKey) {
        return this.getJobDetails().get(jobKey) != null;
    }

    @Override
    public void refresh() {
        try {
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
                try {
                    this.deleteAllTriggers();
                    if (this.scheduler.getListenerManager().getTriggerListener(this.triggerListener.getName()) == null) {
                        this.scheduler.getListenerManager().addTriggerListener(this.triggerListener);
                    }
                    if (this.scheduler.getListenerManager().getJobListener(this.batchExecutionDateHelper.getName()) == null) {
                        this.scheduler.getListenerManager().addJobListener((JobListener)this.batchExecutionDateHelper);
                    }
                    if (this.scheduler.getListenerManager().getJobListener(this.batchExecutionEndHelper.getName()) == null) {
                        this.scheduler.getListenerManager().addJobListener((JobListener)this.batchExecutionEndHelper);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            for (String groupName : this.scheduler.getJobGroupNames()) {
                for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupContains((String)groupName))) {
                    if (this.isJobActif(jobKey)) continue;
                    this.scheduler.deleteJob(jobKey);
                }
            }
            for (JobDetail jobDetail : this.getJobDetails().values()) {
                this.scheduler.addJob(jobDetail, true);
            }
            this.getTriggerFactory().getSequenceTriggerService().init();
            this.reScheduleAllTrigger();
        }
        catch (SchedulerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void reScheduleAllTrigger() throws SchedulerException {
        this.deleteAllTriggers();
        this.scheduleAllTriggers();
    }

    private void scheduleAllTriggers() throws SchedulerException {
        Map<String, SequenceTrigger> triggerMap = this.getSequenceTriggers();
        for (String key : triggerMap.keySet()) {
            SequenceTrigger sequenceTrigger = triggerMap.get(key);
            JobDetail job = JobBuilder.newJob(SequenceJob.class).usingJobData(new JobDataMap(sequenceTrigger.getSequence())).withIdentity(SchedulerManagerHelper.getJobNameFromTrigger(key), "DEFAULT").withDescription(sequenceTrigger.getDescription()).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(key, "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)sequenceTrigger.getCronExpression())).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        this.scheduler.resumeAll();
    }

    private void deleteAllTriggers() throws SchedulerException {
        for (String groupName : this.scheduler.getTriggerGroupNames()) {
            for (TriggerKey triggerKey : this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupContains((String)groupName))) {
                this.scheduler.unscheduleJob(triggerKey);
            }
        }
    }

    public BatchExecutionDateHelper getBatchExecutionDateHelper() {
        return this.batchExecutionDateHelper;
    }

    public void setBatchExecutionDateHelper(BatchExecutionDateHelper batchExecutionDateHelper) {
        this.batchExecutionDateHelper = batchExecutionDateHelper;
    }

    public BatchExecutionEndHelper getBatchExecutionEndHelper() {
        return this.batchExecutionEndHelper;
    }

    public void setBatchExecutionEndHelper(BatchExecutionEndHelper batchExecutionEndHelper) {
        this.batchExecutionEndHelper = batchExecutionEndHelper;
    }
}

