/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.module;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.scheduling.bean.JobParameter;
import com.kportal.scheduling.module.IJobModule;
import com.kportal.scheduling.module.SchedulerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;

public class SchedulerManagerHelper {
    private static final String DEFAULT_NAME_TRIGGER = "Trigger";
    private static final String DEFAULT_NAME_JOB = "Sequence";

    public static SchedulerManager getSchedulerManager() {
        return (SchedulerManager)ApplicationContextManager.getCoreContextBean("schedulerManager");
    }

    public static boolean isJobActif(JobKey jobKey) {
        return SchedulerManagerHelper.getSchedulerManager().isJobActif(jobKey);
    }

    public static String getJobNameFromTrigger(String triggerName) {
        return StringUtils.replace((String)triggerName, (String)DEFAULT_NAME_TRIGGER, (String)DEFAULT_NAME_JOB);
    }

    public static String getTriggerName(Long idSequenceTrigger) {
        return idSequenceTrigger + DEFAULT_NAME_TRIGGER;
    }

    public static IJobModule getModuleForJob(String jobName) {
        Map<String, IJobModule> modules = SchedulerManagerHelper.getSchedulerManager().getJobModules();
        return modules.get(jobName);
    }

    public static Map<JobKey, JobDetail> getAllJobs() {
        return SchedulerManagerHelper.getSchedulerManager().getJobDetails();
    }

    public static JobDetail getJob(String idJob) {
        JobKey job = new JobKey(idJob);
        return SchedulerManagerHelper.getAllJobs().get(job);
    }

    public static List<JobParameter> getParametersForJob(String idJob) {
        ArrayList<JobParameter> params = new ArrayList<JobParameter>();
        JobDetail details = SchedulerManagerHelper.getJob(idJob);
        JobDataMap jdm = details.getJobDataMap();
        for (String key : jdm.keySet()) {
            JobParameter param = new JobParameter(key, jdm.get((Object)key));
            params.add(param);
        }
        return params;
    }
}

