/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.monitoring.impl.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;

public class BatchExecutionDateHelper
extends JobListenerSupport {
    private static final String NAME = "BatchExecutionDateHelper";
    private final Map<String, Date> jobNamesAndLastExecutionDate = Collections.synchronizedMap(new HashMap());

    public String getName() {
        return NAME;
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        this.jobNamesAndLastExecutionDate.put(BatchExecutionDateHelper.getJobLastExecutionDateKey(context.getJobDetail().getKey().getName(), context.getJobDetail().getKey().getGroup()), new Date());
    }

    public Date getJobLastExecutionDate(String jobName, String groupName) {
        return this.jobNamesAndLastExecutionDate.get(BatchExecutionDateHelper.getJobLastExecutionDateKey(jobName, groupName));
    }

    private static String getJobLastExecutionDateKey(String jobName, String groupName) {
        StringBuffer buf = new StringBuffer();
        buf.append(jobName);
        if (groupName != null) {
            buf.append(groupName);
        }
        return buf.toString();
    }
}

