/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.monitoring.impl.quartz;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.listeners.JobListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchExecutionEndHelper
extends JobListenerSupport {
    private static final String NAME = "BatchExecutionEndHelper";
    Logger LOGGER = LoggerFactory.getLogger(BatchExecutionEndHelper.class);
    private final Set<JobKey> jobNamesAndStatus = Collections.synchronizedSet(new HashSet(1));

    public String getName() {
        return NAME;
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (this.jobNamesAndStatus.contains(context.getJobDetail().getKey())) {
            this.jobNamesAndStatus.remove(context.getJobDetail().getKey());
            this.LOGGER.debug("Fin du job : " + context.getJobDetail().getKey().getName());
        }
        super.jobWasExecuted(context, jobException);
    }

    public void jobWasExecuted(JobKey key) {
        if (this.jobNamesAndStatus.contains(key)) {
            this.jobNamesAndStatus.remove(key);
            this.LOGGER.debug("Fin du job : " + key);
        }
    }

    public boolean isJobEnded(String jobName, String groupName) {
        return !this.jobNamesAndStatus.contains(new JobKey(jobName, groupName));
    }

    public void jobToBeExecuted(String jobName, String groupName) {
        this.jobNamesAndStatus.add(new JobKey(jobName, groupName));
        this.LOGGER.debug("Execution du job : " + jobName);
    }

    public boolean isJobStarted(String jobName, String groupName) {
        return this.jobNamesAndStatus.contains(new JobKey(jobName, groupName));
    }

    public boolean isJobRunning() {
        return this.jobNamesAndStatus.size() > 0;
    }

    public JobKey getJobKeyRunning() {
        Iterator<JobKey> iterator = this.jobNamesAndStatus.iterator();
        if (iterator.hasNext()) {
            JobKey key = iterator.next();
            return key;
        }
        return null;
    }
}

