/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.monitoring.impl.quartz;

import com.kportal.scheduling.module.SchedulerManager;
import com.kportal.scheduling.monitoring.BatchMonitoringService;
import com.kportal.scheduling.monitoring.JobInfos;
import com.kportal.scheduling.monitoring.exception.BatchMonitoringException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class BatchMonitoringServiceImplQuartz
implements BatchMonitoringService {
    private SchedulerManager schedulerManager;

    @Override
    public boolean jobExists(String jobName) throws SchedulerException {
        return this.jobExists(jobName, "DEFAULT");
    }

    @Override
    public boolean jobExists(String jobName, String groupName) throws SchedulerException {
        return this.schedulerManager.getScheduler().getJobDetail(new JobKey(jobName, groupName)) != null;
    }

    @Override
    public JobInfos getJobInfos(String jobName) throws BatchMonitoringException {
        return this.getJobInfos(jobName, "DEFAULT");
    }

    @Override
    public JobInfos getJobInfos(String jobName, String groupName) throws BatchMonitoringException {
        try {
            JobInfos jobInfos = new JobInfos();
            JobDetail jobDetail = this.schedulerManager.getScheduler().getJobDetail(new JobKey(jobName, groupName));
            JobExecutionContext jobExecutionContext = this.getJobExecutionContext(jobName, groupName);
            jobInfos.setGroupName(jobDetail.getKey().getGroup());
            jobInfos.setJobName(jobDetail.getKey().getName());
            jobInfos.setNextFireDate(this.getJobNextFireDate(jobName, groupName));
            jobInfos.setLastFireDate(this.getJobLastFireDate(jobName, groupName));
            if (jobExecutionContext != null) {
                jobInfos.setRunning(true);
                jobInfos.setCurrentFireTime(jobExecutionContext.getFireTime());
            } else {
                jobInfos.setRunning(false);
                jobInfos.setCurrentFireTime(null);
            }
            return jobInfos;
        }
        catch (SchedulerException e) {
            throw new BatchMonitoringException(e);
        }
    }

    @Override
    public JobInfos startJob(JobInfos jobInfos, Map<String, Object> additionalParameters) throws BatchMonitoringException {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            if (additionalParameters != null) {
                jobDataMap.putAll(additionalParameters);
            }
            this.startJob(new JobKey(jobInfos.getJobName(), jobInfos.getGroupName()), jobDataMap, false);
        }
        catch (SchedulerException e) {
            throw new BatchMonitoringException(e);
        }
        return this.getJobInfos(jobInfos.getJobName(), jobInfos.getGroupName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startJob(JobKey jobKey, JobDataMap jobDataMap, boolean resumeAll) throws SchedulerException {
        Scheduler scheduler = this.schedulerManager.getScheduler();
        synchronized (scheduler) {
            if (!this.areJobsRunning()) {
                this.schedulerManager.getBatchExecutionEndHelper().jobToBeExecuted(jobKey.getName(), jobKey.getGroup());
                this.schedulerManager.getScheduler().triggerJob(jobKey, jobDataMap);
                if (resumeAll) {
                    this.schedulerManager.getScheduler().resumeJob(jobKey);
                }
            }
        }
    }

    @Override
    public JobInfos startJob(JobInfos jobInfos) throws BatchMonitoringException {
        return this.startJob(jobInfos, null);
    }

    @Override
    public JobInfos pauseJob(JobInfos jobInfos) throws BatchMonitoringException {
        try {
            this.schedulerManager.getScheduler().pauseJob(new JobKey(jobInfos.getJobName(), jobInfos.getGroupName()));
        }
        catch (SchedulerException e) {
            throw new BatchMonitoringException(e);
        }
        return this.getJobInfos(jobInfos.getJobName(), jobInfos.getGroupName());
    }

    @Override
    public JobInfos resumeJob(JobInfos jobInfos) throws BatchMonitoringException {
        try {
            this.schedulerManager.getScheduler().resumeJob(new JobKey(jobInfos.getJobName(), jobInfos.getGroupName()));
        }
        catch (SchedulerException e) {
            throw new BatchMonitoringException(e);
        }
        return this.getJobInfos(jobInfos.getJobName(), jobInfos.getGroupName());
    }

    private Date getJobNextFireDate(String jobName, String groupName) throws BatchMonitoringException {
        Date result = null;
        try {
            List triggers = this.schedulerManager.getScheduler().getTriggersOfJob(new JobKey(jobName, groupName));
            for (Trigger trigger : triggers) {
                if (result != null && (trigger.getNextFireTime() == null || !trigger.getNextFireTime().before(result))) continue;
                result = trigger.getNextFireTime();
            }
        }
        catch (SchedulerException e) {
            throw new BatchMonitoringException(e);
        }
        return result;
    }

    private Date getJobLastFireDate(String jobName, String groupName) throws BatchMonitoringException {
        return this.schedulerManager.getBatchExecutionDateHelper().getJobLastExecutionDate(jobName, groupName);
    }

    private JobExecutionContext getJobExecutionContext(final String jobName, final String groupName) throws BatchMonitoringException {
        JobExecutionContext result = null;
        try {
            result = (JobExecutionContext)CollectionUtils.find((Collection)this.schedulerManager.getScheduler().getCurrentlyExecutingJobs(), (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    JobExecutionContext jobExecutionContext = (JobExecutionContext)arg0;
                    return StringUtils.equals((CharSequence)jobName, (CharSequence)jobExecutionContext.getJobDetail().getKey().getName()) && StringUtils.equals((CharSequence)groupName, (CharSequence)jobExecutionContext.getJobDetail().getKey().getGroup());
                }
            });
        }
        catch (SchedulerException e) {
            throw new BatchMonitoringException(e);
        }
        return result;
    }

    @Override
    public boolean isJobEnded(String jobName, String groupName) {
        return this.schedulerManager.getBatchExecutionEndHelper().isJobEnded(jobName, groupName);
    }

    @Override
    public boolean isJobStarted(String jobName, String groupName) {
        return this.schedulerManager.getBatchExecutionEndHelper().isJobStarted(jobName, groupName);
    }

    @Override
    public boolean areJobsRunning() throws SchedulerException {
        return this.schedulerManager.getBatchExecutionEndHelper().isJobRunning();
    }

    @Override
    public String getFirstRunningJobName() throws SchedulerException {
        return this.schedulerManager.getBatchExecutionEndHelper().getJobKeyRunning() != null ? this.schedulerManager.getScheduler().getJobDetail(this.schedulerManager.getBatchExecutionEndHelper().getJobKeyRunning()).getDescription() : "";
    }

    @Override
    public String getJobDescription(String jobName) throws SchedulerException {
        return this.schedulerManager.getScheduler().getJobDetail(new JobKey(jobName)).getDescription();
    }

    public SchedulerManager getSchedulerManager() {
        return this.schedulerManager;
    }

    public void setSchedulerManager(SchedulerManager schedulerManager) {
        this.schedulerManager = schedulerManager;
    }
}

