/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.monitoring.impl.quartz;

import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTriggerListener
implements TriggerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchTriggerListener.class);
    public static final String NO_RESUME_AFTER_COMPLETE = "noResumeAfterComplete";
    private Boolean pause = false;

    public String getName() {
        return "batchTriggerListener";
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        try {
            Boolean bl = this.pause;
            synchronized (bl) {
                if (!this.pause.booleanValue()) {
                    context.getScheduler().pauseAll();
                    this.pause = true;
                }
                return false;
            }
        }
        catch (SchedulerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            LOGGER.warn("veto sur l'execution du JOB : impossible mettre en pause les triggers");
            return true;
        }
    }

    public void triggerMisfired(Trigger trigger) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        try {
            Boolean bl = this.pause;
            synchronized (bl) {
                boolean noResume = context.getMergedJobDataMap().getBooleanValue(NO_RESUME_AFTER_COMPLETE);
                if (this.pause.booleanValue() && !noResume) {
                    context.getScheduler().resumeAll();
                    this.pause = false;
                }
            }
        }
        catch (SchedulerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

