/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.kportal.scheduling.bean.JobParameter;
import com.kportal.scheduling.module.IJobModule;
import com.kportal.scheduling.module.SchedulerManagerHelper;
import com.kportal.scheduling.monitoring.BatchMonitoringService;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.utils.json.CodecJSon;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.type.TypeReference;

public abstract class AbstractScriptsAutomatises
extends ProcessusBean {
    protected AutorisationBean autorisations = null;
    protected static final String ECRAN_LISTE = "LISTE";
    protected static final String ECRAN_LISTETRIGGERS = "LISTETRIGGERS";
    protected static final String ECRAN_LOGIN = "LOGIN";
    public static final String ACTION_LISTE = "PARAMETRER";
    public static final String ACTION_LISTER_TRIGGERS = "PLANIFIER";
    protected static final String ACTION_EXECUTER = "EXECUTER";
    protected static final String ACTION_CONFIGURER = "PARAMETRAGE";
    protected static final String DROITS_INSUFFISANTS = "BO_DROITS_INSUFFISANTS";
    protected static final String PEUT_LANCER_OUT = "PEUT_LANCER";
    protected static final String PEUT_PARAMETRER_OUT = "PEUT_PARAMETRER";
    protected static final String PEUT_TELECHARGER_OUT = "PEUT_TELECHARGER";
    protected static final String LISTE_TRIGGERS_OUT = "LISTE_TRIGGERS";
    protected static final String JOB_FIELD = "JOB";
    protected static final String PARAMS_FIELD = "PARAMS";
    protected static final String JOB_PARAMS_OUT = "JOB_PARAMS";
    protected static final String JOB_EXTENSION_ID = "JOB_EXTENSION_ID";
    protected static final String ECRAN_PARAMETRAGE = "PARAMETRAGE";
    protected static final String LISTE_LOADABLE_JOBS = "LISTE_LOADABLE_JOBS";

    public AbstractScriptsAutomatises(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    protected boolean traiterAction() throws Exception {
        return this.etat == 2;
    }

    public void recupererDroits() {
    }

    public void recupererTriggers() {
    }

    public void traiterEXECUTER() throws Exception {
        HashMap<String, Object> jobDataMap;
        BatchMonitoringService monitor = (BatchMonitoringService)ApplicationContextManager.getCoreContextBean("batchMonitoringService");
        String jobName = this.infoBean.getString(JOB_FIELD);
        HashMap<String, Object> hashMap = jobDataMap = SchedulerManagerHelper.getParametersForJob(jobName).size() > 0 ? CodecJSon.decodeStringJSonToClass(this.infoBean.getString(PARAMS_FIELD), new TypeReference<HashMap<String, Object>>(){}) : new HashMap<String, Object>();
        if (!monitor.areJobsRunning()) {
            monitor.startJob(monitor.getJobInfos(jobName), jobDataMap);
        }
        this.traiterLISTE();
    }

    public void traiterCONFIGURER() {
        String jobName = this.infoBean.getString(JOB_FIELD);
        List<JobParameter> params = SchedulerManagerHelper.getParametersForJob(jobName);
        IJobModule module = SchedulerManagerHelper.getModuleForJob(jobName);
        this.infoBean.set(JOB_EXTENSION_ID, module.getExtension().getId());
        this.infoBean.set(JOB_PARAMS_OUT, params);
        this.ecranLogique = "PARAMETRAGE";
    }

    public void traiterLISTE() {
        this.recupererDroits();
        this.recupererTriggers();
        this.ecranLogique = ECRAN_LISTE;
    }

    public void traiterLISTERTRIGGERS() {
        this.recupererDroits();
        this.recupererTriggers();
        this.ecranLogique = ECRAN_LISTETRIGGERS;
    }
}

