/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.processus.util.ActionManagerUtil;
import com.kportal.scheduling.processus.AbstractScriptsAutomatises;
import com.kportal.scheduling.service.SequenceTriggerServiceImpl;
import com.kportal.scheduling.util.ScriptsAutomatisesUtil;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.PermissionBean;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptsAutomatises
extends AbstractScriptsAutomatises {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptsAutomatises.class);

    public ScriptsAutomatises(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    protected boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            if (!ScriptsAutomatisesUtil.possedePermissionComposant(this.autorisations)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                ActionManagerUtil amu = new ActionManagerUtil(this, this.autorisations);
                amu.setInsufficientRightsMessage(MessageHelper.getCoreMessage("BO_DROITS_INSUFFISANTS"));
                ArrayList<PermissionBean> consultation = new ArrayList<PermissionBean>();
                ArrayList<PermissionBean> lancement = new ArrayList<PermissionBean>();
                ArrayList<PermissionBean> parametrage = new ArrayList<PermissionBean>();
                parametrage.add(ScriptsAutomatisesUtil.getPermissionParametrage());
                amu.register("PARAMETRER", "traiterLISTE", consultation);
                amu.register("PLANIFIER", "traiterLISTERTRIGGERS", parametrage);
                amu.register("EXECUTER", "traiterEXECUTER", lancement);
                amu.register("PARAMETRAGE", "traiterCONFIGURER", lancement);
                amu.invoke(this.action);
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    @Override
    public void recupererDroits() {
        boolean all = this.autorisations.possedePermission(ScriptsAutomatisesUtil.getPermissionLancement());
        List<Object> jobloadable = new ArrayList();
        if (!all) {
            jobloadable = ScriptsAutomatisesUtil.getLoadableJobs(this.autorisations);
        }
        this.infoBean.set("PEUT_LANCER", all);
        this.infoBean.set("LISTE_LOADABLE_JOBS", jobloadable);
        this.infoBean.set("PEUT_PARAMETRER", false);
        this.infoBean.set("PEUT_TELECHARGER", this.autorisations.possedePermission(ScriptsAutomatisesUtil.getPermissionTelechargement()));
    }

    @Override
    public void recupererTriggers() {
        SequenceTriggerServiceImpl stsi = new SequenceTriggerServiceImpl();
        this.infoBean.set("LISTE_TRIGGERS", stsi.getSequenceTriggers());
    }
}

