/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.spring.quartz;

import ch.qos.logback.classic.Level;
import com.kportal.scheduling.module.SchedulerManagerHelper;
import com.univ.batch.LogReport;
import com.univ.batch.LogReporter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public abstract class LogReportJob
implements Job,
LogReporter {
    public Logger logger;
    public static final String LOGNAME_KEY = "lastLogFileName";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.init(context);
        LogReport logReport = new LogReport(this.getLogFileName(), this.getLogLevel(), this.isReportByMail(), this.getReportSubject());
        this.logger = logReport.getLogger();
        context.getJobDetail().getJobDataMap().put(LOGNAME_KEY, logReport.getLogFilename());
        Long start = System.currentTimeMillis();
        this.logger.info("DEBUT " + this.getClass().getSimpleName());
        this.perform();
        Long duree = System.currentTimeMillis() - start;
        this.logger.info("FIN " + this.getClass().getSimpleName() + ", dur\u00e9e : " + String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(duree), TimeUnit.MILLISECONDS.toMinutes(duree) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duree)), TimeUnit.MILLISECONDS.toSeconds(duree) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duree))));
        logReport.close();
    }

    public abstract void perform();

    @Override
    public String getLogFileName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public String getReportSubject() {
        return "";
    }

    @Override
    public Level getLogLevel() {
        return Level.INFO;
    }

    @Override
    public String getLogDescription() {
        Map<JobKey, JobDetail> jobDetails = SchedulerManagerHelper.getSchedulerManager().getJobDetails();
        for (JobKey key : jobDetails.keySet()) {
            JobDetail value = jobDetails.get(key);
            if (!value.getJobClass().equals(this.getClass())) continue;
            return value.getDescription();
        }
        return "";
    }

    @Override
    public boolean isReportByMail() {
        return false;
    }

    public void init(JobExecutionContext context) {
    }
}

