/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.spring.quartz;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.scheduling.module.SchedulerManagerHelper;
import com.kportal.scheduling.monitoring.BatchMonitoringService;
import com.kportal.scheduling.monitoring.JobInfos;
import com.kportal.scheduling.monitoring.exception.BatchMonitoringException;
import com.kportal.scheduling.monitoring.impl.quartz.BatchExecutionEndHelper;
import com.kportal.scheduling.monitoring.impl.quartz.BatchMonitoringServiceImplQuartz;
import com.kportal.scheduling.spring.quartz.SequenceJobDetail;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SequenceJob
implements Job {
    public static final String PREVIOUS_FIRE_TIME = "previousFireTime";
    public static final String FIRE_TIME = "fireTime";
    public static final String NEXT_FIRE_TIME = "nextFireTime";
    Logger LOGGER = LoggerFactory.getLogger(SequenceJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            JobDetail sequence = jobExecutionContext.getJobDetail();
            JobKey sequenceKey = sequence.getKey();
            this.LOGGER.debug("Execution de la s\u00e9quence : " + sequenceKey.getName());
            TreeSet<Integer> keys = new TreeSet<Integer>();
            for (String string : sequence.getJobDataMap().keySet()) {
                try {
                    keys.add(Integer.parseInt(string));
                }
                catch (Exception e) {
                    this.LOGGER.error("Impossible de parser la cl\u00e9 du sous job " + ((JobDetail)sequence.getJobDataMap().get((Object)string)).getKey().getName());
                }
            }
            block9: for (Integer n : keys) {
                JobKey jobKey;
                SequenceJobDetail jobDetail = (SequenceJobDetail)((Object)sequence.getJobDataMap().get((Object)n.toString()));
                JobDataMap jobDataMap = jobDetail.getSequenceJobDataMap();
                if (jobDataMap == null) {
                    jobDataMap = new JobDataMap();
                }
                jobDataMap.put(PREVIOUS_FIRE_TIME, (Object)jobExecutionContext.getPreviousFireTime());
                jobDataMap.put(FIRE_TIME, (Object)jobExecutionContext.getFireTime());
                jobDataMap.put(NEXT_FIRE_TIME, (Object)jobExecutionContext.getNextFireTime());
                jobDataMap.put("noResumeAfterComplete", true);
                if (jobDetail.getJobDataMap() != null) {
                    for (String keyData : jobDetail.getJobDataMap().keySet()) {
                        if (jobDataMap.containsKey((Object)keyData)) continue;
                        jobDataMap.put(keyData, jobDetail.getJobDataMap().get((Object)keyData));
                    }
                }
                if (SchedulerManagerHelper.isJobActif(jobKey = jobDetail.getKey())) {
                    boolean blockingJob = jobDetail.isBlocking();
                    try {
                        BatchMonitoringService batchMonitoringService = (BatchMonitoringService)ApplicationContextManager.getCoreContextBean("batchMonitoringService");
                        batchMonitoringService.startJob(jobKey, jobDataMap, true);
                        boolean isRunningRenseigne = false;
                        JobInfos jobInfos = null;
                        try {
                            jobInfos = batchMonitoringService.getJobInfos(jobKey.getName(), jobKey.getGroup());
                            isRunningRenseigne = jobInfos.isRunning();
                        }
                        catch (BatchMonitoringException e) {
                            this.LOGGER.warn("Impossible de r\u00e9cup\u00e9rer le jobInfo");
                        }
                        int cpt = 0;
                        while (!batchMonitoringService.isJobEnded(jobKey.getName(), jobKey.getGroup())) {
                            Thread.sleep(1000L);
                            if (++cpt < 60) continue;
                            if (this.nettoyageProcessus(jobKey, jobInfos)) {
                                this.LOGGER.warn("Nettoyage des jobs");
                                continue block9;
                            }
                            cpt = 0;
                        }
                        continue;
                    }
                    catch (InterruptedException | SchedulerException e) {
                        this.handleException(e, blockingJob);
                        continue;
                    }
                }
                this.LOGGER.debug("Execution du job" + jobKey.getName() + " d\u00e9sactiv\u00e9e");
            }
        }
        catch (SchedulerException e) {
            throw new JobExecutionException((Throwable)e);
        }
        this.LOGGER.debug("Fin de l'execution de la s\u00e9quence : " + jobExecutionContext.getJobDetail().getKey().getName());
    }

    private boolean nettoyageProcessus(JobKey jobKey, JobInfos jobInfos) throws SchedulerException {
        boolean retour = Boolean.FALSE;
        HashMap lstJobRun = new HashMap();
        BatchMonitoringService monitor = (BatchMonitoringService)ApplicationContextManager.getCoreContextBean("batchMonitoringService");
        if (monitor instanceof BatchMonitoringServiceImplQuartz) {
            for (JobExecutionContext jobExecutionContext : ((BatchMonitoringServiceImplQuartz)monitor).getSchedulerManager().getScheduler().getCurrentlyExecutingJobs()) {
                String jobKeyInstance = jobExecutionContext.getJobDetail().getKey().toString();
                List lst = null;
                lst = lstJobRun.get(jobKeyInstance) != null ? (List)lstJobRun.get(jobKeyInstance) : new ArrayList();
                lst.add(jobExecutionContext);
                lstJobRun.put(jobKeyInstance, lst);
            }
            this.LOGGER.debug("LISTE DES JOBS EN COURS D EXECUTION");
            for (Map.Entry entry : lstJobRun.entrySet()) {
                this.LOGGER.debug("-> {} ; nombre de job: {} ", entry.getKey(), (Object)((List)entry.getValue()).size());
            }
            if (lstJobRun.get(jobKey.toString()) == null) {
                retour = Boolean.TRUE;
                for (JobListener jobListener : ((BatchMonitoringServiceImplQuartz)monitor).getSchedulerManager().getScheduler().getListenerManager().getJobListeners()) {
                    if (!(jobListener instanceof BatchExecutionEndHelper)) continue;
                    ((BatchExecutionEndHelper)jobListener).jobWasExecuted(jobKey);
                }
            } else if (((List)lstJobRun.get(jobKey.toString())).size() > 1) {
                this.LOGGER.warn("le job {} est lanc\u00e9 deux fois", (Object)jobKey.toString());
            }
        }
        return retour;
    }

    private void handleException(Throwable t, boolean blockingJob) throws JobExecutionException {
        if (blockingJob) {
            if (t instanceof JobExecutionException) {
                throw (JobExecutionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JobExecutionException(t);
        }
        this.LOGGER.error("Non blocking exception: " + t.getMessage(), t);
    }
}

