/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.util;

import com.kportal.core.config.MessageHelper;
import com.kportal.scheduling.module.SchedulerManagerHelper;
import com.kportal.scheduling.util.ScriptsAutomatisesUtil;
import com.kportal.servlet.ExtensionServlet;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.utils.SessionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderServlet
extends ExtensionServlet {
    private static final long serialVersionUID = -6211231526718980078L;
    private static final String DROITS_INSUFFISANTS = "BO_DROITS_INSUFFISANTS";
    private static final String BO_ERREUR_TELECHARGEMENT = "BO_ERREUR_TELECHARGEMENT_LOG";
    private static final String BO_OPERATION_INTERDITE = "BO_OPERATION_INTERDITE";
    private static final String TYPE_PARAM = "TYPE";
    private static final String OCTETSTREAM_MIMETYPE = "application/octet-stream";
    private static final String CONTENT_DISPOSITION_FIELD = "Content-Disposition";
    private static final String LOG_OUT = "LOG";
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloaderServlet.class);

    public void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block30: {
            boolean permission;
            Hashtable<String, Object> infosSessions = SessionUtil.getInfosSession(req);
            AutorisationBean autorisation = (AutorisationBean)infosSessions.get("AUTORISATIONS");
            String type = req.getParameter(TYPE_PARAM);
            boolean bl = permission = LOG_OUT.equals(type) && autorisation != null && autorisation.possedePermission(ScriptsAutomatisesUtil.getPermissionTelechargement());
            if (infosSessions.get("CODE") == null || autorisation == null || !permission) {
                LOGGER.error(MessageHelper.getCoreMessage(DROITS_INSUFFISANTS));
                resp.setStatus(403);
                resp.getWriter().write(MessageHelper.getCoreMessage(DROITS_INSUFFISANTS));
                return;
            }
            String jobName = req.getParameter("JOB_NAME");
            try {
                JobDetail jobDetail = SchedulerManagerHelper.getSchedulerManager().getScheduler().getJobDetail(new JobKey(jobName));
                if (jobDetail == null) {
                    LOGGER.error("Impossible de r\u00e9cup\u00e9rer le JobDetail du job [{}]", (Object)jobName);
                    resp.sendError(500);
                    return;
                }
                JobDataMap jobData = jobDetail.getJobDataMap();
                if (jobData == null) {
                    LOGGER.error("Impossible de r\u00e9cup\u00e9rer le JobData du job [{0}]", (Object)jobName);
                    resp.sendError(500);
                    return;
                }
                String filename = jobData.getString("lastLogFileName");
                if (filename == null) break block30;
                File logfile = new File(filename);
                this.definirEntetes(logfile, resp);
                try (FileInputStream in = new FileInputStream(logfile);
                     ServletOutputStream out = resp.getOutputStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.flush();
                }
            }
            catch (SchedulerException se) {
                LOGGER.error(MessageFormat.format("Une erreur est survenue lors de la r\u00e9cup\u00e9ration du fichier log du job [{0}]", jobName), (Throwable)se);
                resp.reset();
                resp.setStatus(500);
                resp.getWriter().write(MessageHelper.getCoreMessage(BO_ERREUR_TELECHARGEMENT));
            }
            catch (IOException ioe) {
                LOGGER.error(MessageFormat.format("Une erreur est survenue lors de la lecture du fichier log du job [{0}]", jobName), (Throwable)ioe);
                resp.reset();
                resp.setStatus(500);
                resp.getWriter().write(MessageHelper.getCoreMessage(BO_ERREUR_TELECHARGEMENT));
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
        resp.getWriter().write(MessageHelper.getCoreMessage(BO_OPERATION_INTERDITE));
    }

    private void definirEntetes(File f, HttpServletResponse resp) throws IOException {
        String mimetype = new MimetypesFileTypeMap().getContentType(f);
        resp.setContentType(mimetype != null ? mimetype : OCTETSTREAM_MIMETYPE);
        resp.setContentLength((int)f.length());
        resp.setHeader(CONTENT_DISPOSITION_FIELD, "attachment; filename=\"" + FilenameUtils.getName((String)f.getName()) + "\"");
    }

    public void init() {
    }
}

