/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.scheduling.util;

import com.kportal.core.autorisation.util.PermissionUtil;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.scheduling.module.IJobModule;
import com.kportal.scheduling.module.SchedulerManagerHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.PermissionBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ScriptsAutomatisesUtil {
    public static final String ID_PERMISSION = "SUPV";
    public static final String ACTION_LANCEMENT = "L";
    public static final String CODE_PERMISSION = "scra";
    public static final String ACTION_PARAMETRAGE = "P";
    public static final String ACTION_TELECHARGEMENT = "T";
    public static final String ID_BEAN_COMPOSANT = "scriptsAutomatises";

    public static PermissionBean getPermissionTelechargement() {
        return PermissionUtil.getPermissionBean(ScriptsAutomatisesUtil.getModule(), CODE_PERMISSION, ACTION_TELECHARGEMENT);
    }

    public static PermissionBean getPermissionLancement() {
        return PermissionUtil.getPermissionBean(ScriptsAutomatisesUtil.getModule(), CODE_PERMISSION, ACTION_LANCEMENT);
    }

    private static IModule getModule() {
        return ModuleHelper.getModule(ID_BEAN_COMPOSANT);
    }

    public static PermissionBean getPermissionLancement(IModule module, String code) {
        return PermissionUtil.getPermissionBean(module, code, ACTION_LANCEMENT);
    }

    public static PermissionBean getPermissionParametrage() {
        return PermissionUtil.getPermissionBean(ScriptsAutomatisesUtil.getModule(), CODE_PERMISSION, ACTION_PARAMETRAGE);
    }

    public static List<String> getLoadableJobs(AutorisationBean autorisation) {
        ArrayList<String> jobloadable = new ArrayList<String>();
        Map<String, IJobModule> map = SchedulerManagerHelper.getSchedulerManager().getJobModules();
        for (String key : map.keySet()) {
            IJobModule module = map.get(key);
            if (!autorisation.possedePermission(ScriptsAutomatisesUtil.getPermissionLancement(module, key))) continue;
            jobloadable.add(key);
        }
        return jobloadable;
    }

    public static boolean possedePermissionComposant(AutorisationBean autorisation) {
        boolean result = false;
        if (autorisation != null) {
            result |= autorisation.possedePermission(ScriptsAutomatisesUtil.getPermissionParametrage());
            result |= autorisation.possedePermission(ScriptsAutomatisesUtil.getPermissionLancement());
            result |= autorisation.possedePermission(ScriptsAutomatisesUtil.getPermissionTelechargement());
            result |= CollectionUtils.isNotEmpty(ScriptsAutomatisesUtil.getLoadableJobs(autorisation));
        }
        return result;
    }
}

