/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.servlet;

import com.kportal.servlet.ExtensionServlet;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ServicesUtil;
import com.univ.utils.URLResolver;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="servletRedirectService", urlPatterns={"/servlet/com.kportal.servlet.ServletRedirectService"}, loadOnStartup=0)
public class ServletRedirectService
extends ExtensionServlet {
    private static final long serialVersionUID = 5851363204347573567L;
    private static Logger LOGGER = LoggerFactory.getLogger(ServletRedirectService.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String urlRedirect = ctx.getInfosSite().getJspFo() + "/error/404.jsp";
        String urlService = "";
        String codeservice = request.getParameter("code");
        ServiceBean service = null;
        if (codeservice != null) {
            try {
                for (ServiceBean s : ctx.calculerListeServicesPush()) {
                    if (!codeservice.equals(s.getCode())) continue;
                    service = s;
                    break;
                }
                if (service != null) {
                    StringBuilder sb = new StringBuilder(ServicesUtil.determinerUrlAccueilService(ctx, service));
                    Map parametreRequete = request.getParameterMap();
                    for (Map.Entry param : parametreRequete.entrySet()) {
                        if ("code".equals(param.getKey())) continue;
                        for (String valeurAttribut : (String[])param.getValue()) {
                            sb.append(urlService.contains("?") ? "&" : "?");
                            sb.append((String)param.getKey()).append("=").append(valeurAttribut);
                        }
                    }
                    if (sb.toString().length() > 0) {
                        urlService = sb.toString();
                    }
                } else {
                    ServiceBean serviceBean = ServicesUtil.getService(codeservice);
                    if (StringUtils.isNotBlank((CharSequence)serviceBean.getCode())) {
                        urlRedirect = ctx.getInfosSite().getJspFo() + "/error/403.jsp";
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Impossible de calculer l'url du service " + codeservice);
            }
        }
        if (urlService.length() > 0) {
            response.sendRedirect(URLResolver.getAbsoluteUrl(urlService, ctx));
        } else {
            this.getServletContext().getRequestDispatcher(urlRedirect).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

