/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.support;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.BasicPoolMgr;
import com.jsbsoft.jtf.database.InfosConnexion;
import com.kportal.core.config.PropertyHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.kportal.support.ThreadMonitor;
import com.univ.multisites.Site;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;

public class DumpMonitor
extends LogReportJob {
    public static final String TYPE_DUMP = "typeDump";
    public static final String THREADS = "threads";
    public static final String CONNEXIONS = "connexions";
    public static final String ID_BEAN = "dumpMonitor";
    public static final String ID_THREAD_MONITOR = "threadMonitor";
    public static final String THREADS_FOR_DUMP = "300";
    public static final String CONNEXIONS_FOR_DUMP = "300";
    private long nbThreadsForDump;
    private long nbConnexionsForDump;
    private String type;
    private ThreadMonitor threadMonitor;

    @Override
    public void perform() {
        System.currentTimeMillis();
        if (CONNEXIONS.equalsIgnoreCase(this.type)) {
            this.dumpPool();
        } else if (THREADS.equalsIgnoreCase(this.type)) {
            this.dumpThread();
        }
    }

    private void dumpPool() {
        try {
            StringBuilder sBuilder = new StringBuilder();
            String nr = System.getProperty("line.separator");
            sBuilder.append("Monitoring du pool" + nr + nr);
            sBuilder.append("max active : " + BasicPoolMgr.getNombreConnexionsOuvertes() + nr);
            sBuilder.append("max iddle : " + BasicPoolMgr.getNombreConnexionsDisponibles() + nr);
            this.logger.info(sBuilder.toString());
            sBuilder = new StringBuilder();
            sBuilder.append("Traces d'appel du pool" + nr + nr);
            ArrayList<InfosConnexion> lstConnections = BasicPoolMgr.getCurrentConnections();
            sBuilder.append("nombre de connexions non ferm\u00e9es : " + lstConnections.size() + nr);
            for (InfosConnexion infos : lstConnections) {
                if (infos.estDisponible()) continue;
                sBuilder.append("Trace : " + infos.hashCode() + nr);
                StackTraceElement[] stack = infos.getStackTrace();
                for (int i = stack.length - 1; i >= 0; --i) {
                    sBuilder.append(" " + stack[i].getClassName() + " | " + stack[i].getMethodName() + " | l." + stack[i].getLineNumber() + nr);
                }
            }
            this.logger.info(sBuilder.toString());
        }
        catch (Exception e) {
            this.logger.error("Erreur dans DumpMonitor.dumpPool() : ", (Throwable)e);
        }
    }

    private void dumpThread() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            ThreadMXBean threads = ManagementFactory.getThreadMXBean();
            StringBuilder sBuilder = new StringBuilder();
            String nr = System.getProperty("line.separator");
            sBuilder.append("Monitoring des threads" + nr + nr);
            sBuilder.append("thread-count : " + Long.toString(threads.getThreadCount()) + nr);
            sBuilder.append("total-started-thread-count : " + Long.toString(threads.getTotalStartedThreadCount()) + nr);
            sBuilder.append("daemon-thread-count : " + Long.toString(threads.getDaemonThreadCount()) + nr);
            sBuilder.append("peak-thread-count : " + Long.toString(threads.getPeakThreadCount()) + nr);
            this.logger.info(sBuilder.toString());
            long totalCpuTime = 0L;
            long totalUserTime = 0L;
            ThreadInfo[] threadInfos = threads.getThreadInfo(threads.getAllThreadIds(), Integer.MAX_VALUE);
            sBuilder = new StringBuilder();
            sBuilder.append("D\u00e9tail des threads" + nr + nr);
            for (ThreadInfo threadInfo : threadInfos) {
                if (threads.getThreadCpuTime(threadInfo.getThreadId()) > 0L) {
                    sBuilder.append("id : " + threadInfo.getThreadId() + nr);
                    sBuilder.append("nom : " + threadInfo.getThreadName());
                    sBuilder.append("cpu-time-ms : " + Long.toString(threads.getThreadCpuTime(threadInfo.getThreadId()) / 1000000L) + nr);
                    sBuilder.append("blocked-count : " + Long.toString(threadInfo.getBlockedCount()) + nr);
                    sBuilder.append("blocked-time : " + Long.toString(threadInfo.getBlockedTime()) + nr);
                    sBuilder.append("waited-count : " + Long.toString(threadInfo.getWaitedCount()) + nr);
                    sBuilder.append("waited-time : " + Long.toString(threadInfo.getWaitedTime()) + nr);
                }
                totalCpuTime += threads.getThreadCpuTime(threadInfo.getThreadId());
                totalUserTime += threads.getThreadUserTime(threadInfo.getThreadId());
            }
            this.logger.info(sBuilder.toString());
            sBuilder = new StringBuilder();
            sBuilder.append("Temps d'utilisation globaux" + nr + nr);
            long totalCpuTimeMs = totalCpuTime / 1000000L;
            long totalUserTimeMs = totalUserTime / 1000000L;
            long uptime = runtime.getUptime();
            double cpuPercentage = (double)totalCpuTimeMs / (double)uptime * 100.0;
            double userPercentage = (double)totalUserTimeMs / (double)uptime * 100.0;
            sBuilder.append("total-cpu-time-ms : " + Long.toString(totalCpuTimeMs) + nr);
            sBuilder.append("total-user-time-ms : " + Long.toString(totalUserTimeMs) + nr);
            sBuilder.append("uptime : " + Long.toString(uptime) + nr);
            sBuilder.append("total-cpu-percent : " + Double.toString(cpuPercentage) + nr);
            sBuilder.append("total-user-percent : " + Double.toString(userPercentage) + nr);
            this.logger.info(sBuilder.toString());
            this.logger.info("Dump des threads" + nr + this.threadMonitor.getFullThreadDump());
        }
        catch (Exception e) {
            this.logger.error("Erreur dans DumpMonitor.dumpThread() : ", (Throwable)e);
        }
    }

    @Override
    public void init(JobExecutionContext jobCtx) {
        this.type = jobCtx.getMergedJobDataMap().getString(TYPE_DUMP);
        this.nbThreadsForDump = new Long((String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty("dumpMonitor.nbThreadsForDump"), (CharSequence)"300"));
        this.nbConnexionsForDump = new Long((String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty("dumpMonitor.nbConnexionsForDump"), (CharSequence)"300"));
        this.threadMonitor = (ThreadMonitor)ApplicationContextManager.getCoreContextBean(ID_THREAD_MONITOR);
    }

    @Override
    public boolean isReportByMail() {
        if (CONNEXIONS.equalsIgnoreCase(this.type)) {
            return (long)BasicPoolMgr.getNombreConnexionsOuvertes() > this.nbConnexionsForDump;
        }
        if (THREADS.equalsIgnoreCase(this.type)) {
            return (long)ManagementFactory.getThreadMXBean().getThreadCount() > this.nbThreadsForDump;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getLogFileName() {
        return DumpMonitor.class.getSimpleName().toLowerCase() + (this.type != null ? "-" + this.type : "");
    }

    @Override
    public String getReportSubject() {
        String appli = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty("application.nom"), (CharSequence)Site.getSitePrincipal().getIntitule());
        if (CONNEXIONS.equalsIgnoreCase(this.type)) {
            return "[" + appli + "][DumpMonitor] Alerte nombre de connexions > " + this.nbConnexionsForDump;
        }
        if (THREADS.equalsIgnoreCase(this.type)) {
            return "[" + appli + "][DumpMonitor] Alerte nombre de threads > " + this.nbThreadsForDump;
        }
        return "[" + appli + "][DumpMonitor] Alerte";
    }
}

