/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.support;

import com.kportal.support.ThreadMonitor;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServerConnection;

public class ThreadMonitorImpl15
implements ThreadMonitor {
    private StringBuilder stringBuilder;
    private ThreadMXBean tmbean;
    private static String INDENT = "    ";

    public ThreadMonitorImpl15(MBeanServerConnection server) throws IOException {
        this.tmbean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
        this.stringBuilder = new StringBuilder();
    }

    public ThreadMonitorImpl15() {
        this.tmbean = ManagementFactory.getThreadMXBean();
        this.stringBuilder = new StringBuilder();
    }

    private void threadDump() {
        Long start = System.currentTimeMillis();
        try {
            if (this.tmbean == null) {
                this.tmbean = ManagementFactory.getThreadMXBean();
            }
            this.dumpThreadInfoWithLocks();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            long end = System.currentTimeMillis();
            double time = (double)end / 1000.0 - (double)start.longValue() / 1000.0;
            this.println("Full thread dump : " + time + " seconds");
        }
    }

    private void dumpThreadInfoWithLocks() {
        ThreadInfo[] tinfos;
        this.println("Full Java thread dump with locks info");
        long[] tids = this.tmbean.getAllThreadIds();
        this.println("");
        this.println("Threads: count =" + this.tmbean.getThreadCount());
        for (ThreadInfo ti : tinfos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
            this.printThreadInfo(ti);
        }
        this.findDeadlock();
    }

    private void printThreadInfo(ThreadInfo ti) {
        StackTraceElement[] stacktrace;
        this.printThread(ti);
        for (StackTraceElement ste : stacktrace = ti.getStackTrace()) {
            this.println(INDENT + "at " + ste.toString());
        }
        this.println("");
    }

    private void printThread(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        this.println(sb.toString());
        if (ti.getLockOwnerName() != null) {
            this.println(INDENT + " owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    public boolean findDeadlock() {
        ThreadInfo[] infos;
        long[] tids = this.tmbean.findMonitorDeadlockedThreads();
        if (tids == null) {
            this.println("No Deadlock found.");
            return false;
        }
        this.println("Deadlock found :-");
        for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
            this.printThreadInfo(ti);
        }
        return true;
    }

    public void println(String s) {
        if (this.stringBuilder != null) {
            this.stringBuilder.append(s + System.getProperty("line.separator"));
        } else {
            System.out.println(s);
        }
    }

    @Override
    public String getFullThreadDump() {
        if (this.stringBuilder.length() > 0) {
            this.stringBuilder = new StringBuilder();
        }
        this.threadDump();
        return this.stringBuilder.toString();
    }
}

