/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.tag.interpreteur.impl;

import com.kportal.core.config.PropertyHelper;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import org.apache.commons.lang3.StringUtils;

public class InterpreteurIdFichier
extends AbstractInterpreteurTag {
    protected static String baliseInterneOuvrante = "[id-fichier]";
    protected static String baliseInterneFermante = "[/id-fichier]";

    @Override
    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        String typeDisposition;
        StringBuilder newTexte = new StringBuilder();
        newTexte.append(StringUtils.substringBefore((String)texteAInterpreter, (String)baliseInterneOuvrante));
        String idFichier = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseInterneOuvrante, (String)baliseInterneFermante);
        if (idFichier.startsWith(";")) {
            idFichier = idFichier.substring(1);
        }
        Media media = Media.getMedia(new Long(idFichier));
        String url = media.getUrlAbsolue();
        if (ContexteUtil.getContexteUniv().getFicheCourante() != null) {
            url = url + (url.indexOf("?") != -1 ? "&" : "?") + "ID_FICHE=" + ContexteUtil.getContexteUniv().getFicheCourante().getIdFiche();
        }
        if ((typeDisposition = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty("telechargement.disposition"), (CharSequence)"attachment")).equalsIgnoreCase("attachment")) {
            url = url + (url.indexOf("?") != -1 ? "&" : "?") + "INLINE=FALSE";
        }
        newTexte.append(URLResolver.getAbsoluteUrl(url, ContexteUtil.getContexteUniv()));
        String title = StringUtils.isBlank((CharSequence)media.getTitre()) ? media.getSource() : media.getTitre();
        String weight = "%d %s";
        weight = media.getPoids() > 1000000 ? String.format(weight, media.getPoids() / 1000000, "Go") : (media.getPoids() > 1000 ? String.format(weight, media.getPoids() / 1000, "Mo") : String.format(weight, media.getPoids(), "Ko"));
        newTexte.append(String.format("\" title=\"T\u00e9l\u00e9charger '%s' [%s - %s]", title, media.getExtension().toUpperCase(), weight));
        newTexte.append(StringUtils.substringAfter((String)texteAInterpreter, (String)baliseInterneFermante));
        return newTexte.toString();
    }

    @Override
    public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        try {
            return this.interpreterTag(texteAInterpreter, baliseOuvrante, baliseFermante);
        }
        catch (Exception e) {
            return "";
        }
    }
}

