/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.tag.interpreteur.impl;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class InterpreteurLienFiches
extends AbstractInterpreteurTag {
    @Override
    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        String param = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseOuvrante, (String)baliseFermante);
        param = StringEscapeUtils.unescapeHtml4((String)param);
        param = StringUtils.replace((String)param, (String)"#", (String)"&");
        return this.formatTagLienFiche(ContexteUtil.getContexteUniv(), param);
    }

    private String formatTagLienFiche(ContexteUniv _ctx, String paramExit) throws Exception {
        String res;
        block99: {
            res = "";
            boolean erreur = false;
            boolean modificationFiche = false;
            boolean suppressionFiche = false;
            boolean creationFiche = false;
            boolean validationFiche = false;
            TreeMap<Object, FicheUniv> treeNomObjet = new TreeMap<Object, FicheUniv>();
            String chaineObjet = RequeteUtil.renvoyerParametre(paramExit, "OBJET", true);
            String actionLien = RequeteUtil.renvoyerParametre(paramExit, "ACTION", true);
            String idFiche = RequeteUtil.renvoyerParametre(paramExit, "ID_FICHE");
            String indiceAction = "";
            if (actionLien.equals("AJOUTER")) {
                creationFiche = true;
                indiceAction = "C";
            } else if (actionLien.equals("MODIFIER")) {
                modificationFiche = true;
                indiceAction = "M";
            } else if (actionLien.equals("SUPPRIMER")) {
                suppressionFiche = true;
                indiceAction = "S";
            } else if (actionLien.equals("VALIDER")) {
                validationFiche = true;
                indiceAction = "V";
            } else {
                erreur = true;
            }
            if (modificationFiche || suppressionFiche) {
                Object nomObjet;
                FicheUniv fiche;
                if (idFiche.length() > 0 && chaineObjet.length() > 0) {
                    fiche = ReferentielObjets.instancierFiche(chaineObjet.toUpperCase());
                    fiche.init();
                    fiche.setCtx(_ctx);
                    if (fiche != null) {
                        try {
                            nomObjet = chaineObjet.toUpperCase();
                            fiche.setIdFiche(Long.parseLong(idFiche));
                            fiche.retrieve();
                            treeNomObjet.put(nomObjet, fiche);
                        }
                        catch (Exception e) {
                            erreur = true;
                        }
                    }
                } else if (_ctx.getFicheCourante() != null) {
                    fiche = _ctx.getFicheCourante();
                    nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(_ctx.getFicheCourante())).toUpperCase();
                    treeNomObjet.put(nomObjet, fiche);
                } else {
                    erreur = true;
                }
            }
            if (creationFiche) {
                Collection<String> listeObjets = null;
                listeObjets = chaineObjet.length() > 0 ? Arrays.asList(chaineObjet.split(",", -2)) : ReferentielObjets.getListeNomsObjet();
                for (String nomObj : listeObjets) {
                    FicheUniv fiche = ReferentielObjets.instancierFiche(nomObj);
                    if (fiche == null) continue;
                    fiche.init();
                    if (fiche instanceof DiffusionSelective) {
                        ((DiffusionSelective)((Object)fiche)).setDiffusionPublicVise("");
                        if (StringUtils.isNotEmpty((CharSequence)_ctx.getEspaceCourant())) {
                            ((DiffusionSelective)((Object)fiche)).setDiffusionModeRestriction("4");
                            ((DiffusionSelective)((Object)fiche)).setDiffusionPublicViseRestriction(_ctx.getEspaceCourant());
                        } else {
                            ((DiffusionSelective)((Object)fiche)).setDiffusionModeRestriction("");
                            ((DiffusionSelective)((Object)fiche)).setDiffusionPublicViseRestriction("");
                        }
                    }
                    treeNomObjet.put(nomObj, fiche);
                }
            }
            if (validationFiche) {
                for (String nom : ReferentielObjets.getListeNomsObjet()) {
                    FicheUniv ficheInstancie = ReferentielObjets.instancierFiche(nom);
                    if (ficheInstancie == null) continue;
                    treeNomObjet.put(nom.toUpperCase(), ficheInstancie);
                    break;
                }
            }
            if (treeNomObjet.size() == 0) {
                erreur = true;
            }
            if (erreur) break block99;
            String title = RequeteUtil.renvoyerParametre(paramExit, "TITLE");
            String libelle = RequeteUtil.renvoyerParametre(paramExit, "LIBELLE");
            String classCss = RequeteUtil.renvoyerParametre(paramExit, "CLASSE_CSS");
            if (classCss.length() > 0) {
                classCss = "class=\"" + classCss.toLowerCase() + "\"";
            }
            String separateur = RequeteUtil.renvoyerParametre(paramExit, "SEPARATEUR");
            String codeRattachement = RequeteUtil.renvoyerParametre(paramExit, "CODE_RATTACHEMENT");
            String codeRubrique = RequeteUtil.renvoyerParametre(paramExit, "CODE_RUBRIQUE");
            String chaineDsi = RequeteUtil.renvoyerParametre(paramExit, "DIFFUSION_PUBLIC_VISE");
            String urlRedirect = RequeteUtil.renvoyerParametre(paramExit, "URL_REDIRECT");
            Vector<String> listeGroupe = new Vector<String>();
            if (StringUtils.isEmpty((CharSequence)urlRedirect) && _ctx.getRequeteHTTP() != null && !suppressionFiche) {
                InfoBean infoBean = (InfoBean)_ctx.getRequeteHTTP().getAttribute("infoBean");
                if (_ctx.getRequeteHTTP().getAttribute("URL_REDIRECT") != null) {
                    urlRedirect = urlRedirect + _ctx.getRequeteHTTP().getAttribute("URL_REDIRECT");
                } else if (infoBean != null && infoBean.get("URL_REDIRECT") != null) {
                    urlRedirect = urlRedirect + ((InfoBean)_ctx.getRequeteHTTP().getAttribute("infoBean")).get("URL_REDIRECT");
                } else if (StringUtils.isNotBlank((CharSequence)_ctx.getUrlPageCourante())) {
                    urlRedirect = _ctx.getUrlPageCourante();
                }
            }
            for (String nomObjet : treeNomObjet.keySet()) {
                String requete;
                boolean bl;
                String codeObjet;
                FicheUniv fiche;
                boolean prevalorisePublicVise;
                boolean prevaloriseRubrique;
                boolean prevaloriseStructure;
                boolean saisieAnonyme;
                boolean afficheLien;
                block100: {
                    block102: {
                        block101: {
                            afficheLien = true;
                            saisieAnonyme = false;
                            prevaloriseStructure = false;
                            prevaloriseRubrique = false;
                            prevalorisePublicVise = false;
                            fiche = (FicheUniv)treeNomObjet.get(nomObjet);
                            codeObjet = ReferentielObjets.getCodeObjet(fiche);
                            if (creationFiche) {
                                if (StringUtils.isBlank((CharSequence)libelle)) {
                                    libelle = "Saisir une fiche " + ReferentielObjets.getLibelleObjet(codeObjet);
                                }
                                if (StringUtils.isBlank((CharSequence)title)) {
                                    title = "Saisir une fiche " + ReferentielObjets.getLibelleObjet(codeObjet);
                                }
                            }
                            if (modificationFiche) {
                                if (StringUtils.isBlank((CharSequence)libelle)) {
                                    libelle = "Modifier la fiche " + ReferentielObjets.getLibelleObjet(codeObjet);
                                }
                                if (StringUtils.isBlank((CharSequence)title)) {
                                    title = "Modifier la fiche " + ReferentielObjets.getLibelleObjet(codeObjet);
                                }
                            }
                            if (suppressionFiche) {
                                if (StringUtils.isBlank((CharSequence)libelle)) {
                                    libelle = "Supprimer la fiche " + ReferentielObjets.getLibelleObjet(codeObjet);
                                }
                                if (StringUtils.isBlank((CharSequence)title)) {
                                    title = "Supprimer la fiche " + ReferentielObjets.getLibelleObjet(codeObjet);
                                }
                            }
                            if (validationFiche) {
                                if (StringUtils.isBlank((CharSequence)libelle)) {
                                    libelle = "Valider mes fiches";
                                }
                                if (StringUtils.isBlank((CharSequence)title)) {
                                    title = "Valider mes fiches";
                                }
                            }
                            String anonyme = PropertyHelper.getCoreProperty(nomObjet.toLowerCase() + ".anonyme");
                            if (creationFiche && anonyme != null && anonyme.equals("1")) {
                                saisieAnonyme = true;
                            }
                            if (!creationFiche) break block100;
                            if (codeRattachement.length() <= 0) break block101;
                            if (Structure.getFicheStructure(codeRattachement, _ctx.getLangue(), false) == null) break block102;
                            fiche.setCodeRattachement(codeRattachement);
                            prevaloriseStructure = true;
                            break block102;
                        }
                        if (_ctx.getAutorisation() != null && _ctx.getAutorisation().possedePermission(new PermissionBean("FICHE", ReferentielObjets.getCodeObjet(fiche), indiceAction))) {
                            Vector<Perimetre> vPerimetre = _ctx.getAutorisation().getListePerimetres(new PermissionBean("FICHE", ReferentielObjets.getCodeObjet(fiche), indiceAction));
                            Enumeration<Perimetre> enumeration = vPerimetre.elements();
                            String structureUtilisateur = _ctx.getAutorisation().getCodeStructure();
                            if (structureUtilisateur.length() > 0) {
                                if (_ctx.getAutorisation().possedePermission(new PermissionBean("FICHE", ReferentielObjets.getCodeObjet(fiche), indiceAction), new Perimetre(structureUtilisateur, "*", "*", "*", ""))) {
                                    codeRattachement = structureUtilisateur;
                                }
                                fiche.setCodeRattachement(codeRattachement);
                                prevaloriseStructure = true;
                            } else {
                                while (enumeration.hasMoreElements()) {
                                    Perimetre perimetreCourant = enumeration.nextElement();
                                    if (perimetreCourant == null || perimetreCourant.getCodeStructure().equals("")) continue;
                                    codeRattachement = perimetreCourant.getCodeStructure();
                                    fiche.setCodeRattachement(codeRattachement);
                                    prevaloriseStructure = true;
                                    break;
                                }
                            }
                        }
                    }
                    if (codeRubrique.length() > 0) {
                        if (codeRubrique.equals("DYNAMIK")) {
                            codeRubrique = _ctx.getCodeRubriquePageCourante();
                        } else if (codeRubrique.equals("ALL")) {
                            codeRubrique = "*";
                        } else if (Rubrique.getRubriqueByCode(codeRubrique) == null) {
                            codeRubrique = "";
                        }
                    }
                    if (codeRubrique.length() > 0) {
                        fiche.setCodeRubrique(codeRubrique);
                        prevaloriseRubrique = true;
                    }
                    if (chaineDsi.length() > 0) {
                        if (chaineDsi.equals("DYNAMIK")) {
                            if (_ctx.getAutorisation() != null && _ctx.getGroupesDsi() != null) {
                                for (String string : _ctx.getGroupesDsi()) {
                                    listeGroupe.add("[/" + string + "]");
                                }
                            }
                        } else {
                            String[] chaineDsiItem = chaineDsi.split(",");
                            chaineDsi = "";
                            String[] stringArray = chaineDsiItem;
                            int structureUtilisateur = stringArray.length;
                            for (int perimetreCourant = 0; perimetreCourant < structureUtilisateur; ++perimetreCourant) {
                                String element;
                                String itemGroupe = element = stringArray[perimetreCourant];
                                if (Groupedsi.renvoyerItemGroupeDsi(itemGroupe = itemGroupe.replaceAll("@", ",")).getCode().equals("")) continue;
                                listeGroupe.add("[/" + itemGroupe + "]");
                            }
                        }
                    }
                    if (fiche instanceof DiffusionSelective && listeGroupe.size() > 0) {
                        chaineDsi = StringUtils.join(listeGroupe, (String)";");
                        ((DiffusionSelective)((Object)fiche)).setDiffusionPublicVise(chaineDsi);
                        prevalorisePublicVise = true;
                    }
                }
                PermissionBean permBean = new PermissionBean("TECH", "dsi", "");
                boolean bl2 = true;
                if (_ctx.getAutorisation() != null && StringUtils.isNotBlank((CharSequence)chaineDsi)) {
                    String[] codesGroupeDsi = StringUtils.remove((String)StringUtils.remove((String)chaineDsi, (String)"[/"), (String)"]").split(";");
                    for (int i = 0; i < codesGroupeDsi.length && bl; ++i) {
                        bl = _ctx.getAutorisation().possedePermissionPartielleSurPerimetre(permBean, new Perimetre("", "", "", codesGroupeDsi[i], ""));
                    }
                }
                if (!saisieAnonyme) {
                    if (_ctx.getAutorisation() != null) {
                        if (suppressionFiche) {
                            afficheLien = _ctx.getAutorisation().estAutoriseASupprimerLaFiche(fiche) && bl;
                        } else if (modificationFiche) {
                            afficheLien = _ctx.getAutorisation().estAutoriseAModifierLaFiche(fiche) && bl;
                        } else if (creationFiche) {
                            afficheLien = _ctx.getAutorisation().getAutorisationParFiche(fiche, 0) && bl;
                        } else if (validationFiche) {
                            afficheLien = _ctx.getAutorisation().isValidateur() && bl;
                        }
                    } else {
                        afficheLien = false;
                    }
                }
                if (codeRubrique.equals("*")) {
                    codeRubrique = "";
                }
                if (!afficheLien) continue;
                String lien = "";
                String libelleLien = libelle;
                if (creationFiche && libelle.equalsIgnoreCase("objet")) {
                    libelleLien = ReferentielObjets.getLibelleObjet(codeObjet);
                }
                if (!(validationFiche || !FicheAnnotationHelper.isSaisieFrontOffice(fiche) || creationFiche && fiche instanceof FicheObjet)) {
                    requete = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + ReferentielObjets.getExtension(codeObjet) + "&amp;PROC=SAISIE_" + nomObjet.toUpperCase() + "_FRONT&amp;ACTION=" + actionLien + "&amp;SAISIE_FRONT=TRUE";
                    if (suppressionFiche) {
                        requete = requete + "&amp;TYPE_FICHE=" + nomObjet;
                    }
                    if (modificationFiche || suppressionFiche) {
                        requete = requete + "&amp;ID_FICHE=" + fiche.getIdFiche().toString();
                    }
                    if (prevaloriseRubrique && !suppressionFiche) {
                        requete = requete + "&amp;PREV_CODE_RUBRIQUE=" + codeRubrique;
                    }
                    if (prevaloriseStructure && !suppressionFiche) {
                        requete = requete + "&amp;PREV_CODE_RATTACHEMENT=" + codeRattachement;
                    }
                    if (prevalorisePublicVise && !suppressionFiche) {
                        requete = requete + "&amp;PREV_DIFFUSION_PUBLIC_VISE=" + chaineDsi;
                    }
                    if (urlRedirect.length() > 0) {
                        requete = requete + "&amp;URL_REDIRECT=" + URLEncoder.encode(urlRedirect, "UTF-8");
                    }
                    lien = "<a " + classCss + " " + (StringUtils.isNotBlank((CharSequence)title) ? "title=\"" + title + "\" " : "") + "href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlRelative(_ctx, requete, true), _ctx) + "\">" + libelleLien + "</a>";
                } else if (!(_ctx.getAutorisation() == null || !_ctx.getAutorisation().possedeModeExpert() || creationFiche && fiche instanceof FicheObjet)) {
                    if (creationFiche || modificationFiche || suppressionFiche) {
                        requete = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + ReferentielObjets.getExtension(codeObjet) + "&amp;PROC=" + ReferentielObjets.getProcessus(codeObjet) + "&amp;ACTION=" + actionLien;
                        if (modificationFiche || suppressionFiche) {
                            requete = requete + "&amp;ID_FICHE=" + fiche.getIdFiche().toString();
                        } else {
                            if (prevaloriseRubrique) {
                                requete = requete + "&amp;PREV_CODE_RUBRIQUE=" + codeRubrique;
                            }
                            if (prevaloriseStructure) {
                                requete = requete + "&amp;PREV_CODE_RATTACHEMENT=" + codeRattachement;
                            }
                            if (prevalorisePublicVise) {
                                requete = requete + "&amp;PREV_DIFFUSION_PUBLIC_VISE=" + chaineDsi;
                            }
                        }
                        lien = "<a " + classCss + " " + (StringUtils.isNotBlank((CharSequence)title) ? "title=\"" + title + "\" " : "") + "href=\"" + URLResolver.getAbsoluteBoUrl(requete, _ctx.getInfosSite()) + "\" onclick=\"window.open(this.href,'_blank','');return false;\">" + libelleLien + "</a>";
                    } else if (validationFiche) {
                        lien = "<a " + classCss + " " + (StringUtils.isNotBlank((CharSequence)title) ? "title=\"" + title + "\" " : "") + "href=\"" + URLResolver.getAbsoluteBoUrl("/servlet/com.jsbsoft.jtf.core.SG?EXT=core&amp;PROC=VALIDATION&amp;ACTION=LISTE", _ctx.getInfosSite()) + "\" onclick=\"window.open(this.href,'_blank','');return false;\">" + libelleLien + "</a>";
                    }
                }
                if (lien.length() <= 0) continue;
                if (separateur.equalsIgnoreCase("li")) {
                    res = res + "<li>" + lien + "</li>\r\n";
                    continue;
                }
                if (res.length() > 0 && separateur.equalsIgnoreCase("br")) {
                    res = res + "<br />" + lien;
                    continue;
                }
                if (res.length() > 0) {
                    res = res + "&nbsp;" + lien;
                    continue;
                }
                res = res + lien;
            }
            if (separateur.equalsIgnoreCase("li")) {
                res = "<ul>" + res + "</ul>";
            }
        }
        return res;
    }

    @Override
    public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        try {
            return this.interpreterTag(texteAInterpreter, baliseOuvrante, baliseFermante);
        }
        catch (Exception e) {
            return "";
        }
    }
}

