/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.tag.interpreteur.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.Formateur;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.AbstractRequeteur;
import com.univ.utils.AttributRequeteur;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteUtil;
import com.univ.utils.RequeteurFiches;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.cache.CacheRequestManager;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class InterpreteurListeFiches
extends AbstractInterpreteurTag {
    @Override
    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        String param = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseOuvrante, (String)baliseFermante);
        param = StringEscapeUtils.unescapeHtml4((String)param);
        param = StringUtils.replace((String)param, (String)"#", (String)"&");
        return this.formatTagListeFiche(ContexteUtil.getContexteUniv(), param);
    }

    private String formatTagListeFiche(ContexteUniv _ctx, String paramExit) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        String res = "";
        if (paramExit.length() > 0) {
            String langue;
            String publicVise;
            String codeRattachement;
            String etat;
            boolean afficheListe = AbstractRequeteur.getBooleanValue(RequeteUtil.renvoyerParametre(paramExit, "LISTE"));
            boolean afficheTableau = AbstractRequeteur.getBooleanValue(RequeteUtil.renvoyerParametre(paramExit, "TAB"));
            String mode = RequeteUtil.renvoyerParametre(paramExit, "MODE", true);
            String actions = RequeteUtil.renvoyerParametre(paramExit, "ACTIONS", true);
            String pagination = RequeteUtil.renvoyerParametre(paramExit, "PAGE");
            String ajout = RequeteUtil.renvoyerParametre(paramExit, "AJOUT");
            String title = RequeteUtil.renvoyerParametre(paramExit, "TITLE");
            String classCss = RequeteUtil.renvoyerParametre(paramExit, "CLASSE_CSS");
            if (classCss.length() > 0) {
                classCss = "class=\"" + classCss.toLowerCase() + "\"";
            }
            String separateur = RequeteUtil.renvoyerParametre(paramExit, "SEPARATEUR");
            String lien = RequeteUtil.renvoyerParametre(paramExit, "LIEN");
            if (lien.equals("")) {
                lien = "Toutes les fiches";
            }
            RequeteurFiches requeteur = new RequeteurFiches(mode, actions, pagination, ajout, "");
            String parametreAttribut = "";
            String titre = RequeteUtil.renvoyerParametre(paramExit, "TITRE");
            if (titre.length() > 0) {
                requeteur.setAttribut("TITRE", titre, false, false);
            }
            if ((etat = RequeteUtil.renvoyerParametre(paramExit, "ETAT")).length() > 0) {
                requeteur.setAttribut("ETAT_OBJET", etat);
            }
            String codeObjet = RequeteUtil.renvoyerParametre(paramExit, "OBJET", true);
            String codeRedacteur = RequeteUtil.renvoyerParametre(paramExit, "CODE_REDACTEUR");
            if (codeRedacteur.contains("|")) {
                parametreAttribut = codeRedacteur.substring(codeRedacteur.indexOf("|"), codeRedacteur.length());
                codeRedacteur = codeRedacteur.substring(0, codeRedacteur.indexOf("|"));
            }
            if (_ctx.getAutorisation() != null && codeRedacteur.equals("DYNAMIK")) {
                codeRedacteur = _ctx.getAutorisation().getCode();
                parametreAttribut = "|0|0";
            }
            if (codeRedacteur.length() > 0 || parametreAttribut.length() > 0) {
                requeteur.setAttribut("CODE_REDACTEUR", codeRedacteur + parametreAttribut);
            }
            parametreAttribut = "";
            String codeRubrique = RequeteUtil.renvoyerParametre(paramExit, "CODE_RUBRIQUE");
            if (codeRubrique.length() > 0) {
                if (codeRubrique.equals("DYNAMIK")) {
                    codeRubrique = _ctx.getCodeRubriquePageCourante();
                }
                requeteur.setAttribut("CODE_RUBRIQUE", codeRubrique);
            }
            if ((codeRattachement = RequeteUtil.renvoyerParametre(paramExit, "CODE_RATTACHEMENT")).length() > 0) {
                requeteur.setAttribut("CODE_RATTACHEMENT", codeRattachement);
            }
            if ((publicVise = RequeteUtil.renvoyerParametre(paramExit, "DIFFUSION_PUBLIC_VISE")).contains("|")) {
                parametreAttribut = publicVise.substring(publicVise.indexOf("|"), publicVise.length());
                publicVise = publicVise.substring(0, publicVise.indexOf("|"));
            }
            if (_ctx.getAutorisation() != null && publicVise.equals("DYNAMIK")) {
                publicVise = Chaine.convertirPointsVirgules(_ctx.getGroupesDsi());
                parametreAttribut = "|0|1";
            }
            if (publicVise.length() > 0 || parametreAttribut.length() > 0) {
                if (publicVise.contains(",")) {
                    parametreAttribut = "|0|1";
                }
                publicVise = publicVise.replaceAll(",", ";");
                publicVise = publicVise.replaceAll("@", ",");
                requeteur.setAttribut("DIFFUSION_PUBLIC_VISE", publicVise + parametreAttribut);
            }
            parametreAttribut = "";
            String codeEspace = RequeteUtil.renvoyerParametre(paramExit, "ESPACE");
            if (codeEspace.length() > 0) {
                requeteur.setAttribut("ESPACE", codeEspace);
            }
            String modeRestriction = "";
            String publicViseRestriction = "";
            if (codeEspace.length() > 0) {
                modeRestriction = "4";
                publicViseRestriction = codeEspace;
            } else {
                modeRestriction = RequeteUtil.renvoyerParametre(paramExit, "DIFFUSION_MODE_RESTRICTION");
                publicViseRestriction = RequeteUtil.renvoyerParametre(paramExit, "DIFFUSION_PUBLIC_VISE_RESTRICTION");
            }
            if (codeObjet.equals("TOUS") || codeObjet.equals("") || codeObjet.equals("0000")) {
                codeObjet = "";
                for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
                    if (modeRestriction.equals("")) {
                        if (objet.isStrictlyCollaboratif()) continue;
                        if (codeObjet.length() > 0) {
                            codeObjet = codeObjet + ",";
                        }
                        codeObjet = codeObjet + objet.getNomObjet();
                        continue;
                    }
                    if (!modeRestriction.equals("4") || !objet.isCollaboratif()) continue;
                    if (codeObjet.length() > 0) {
                        codeObjet = codeObjet + ",";
                    }
                    codeObjet = codeObjet + objet.getNomObjet();
                }
            }
            if (codeObjet.length() > 0) {
                requeteur.setAttribut("CODE_OBJET", codeObjet + parametreAttribut);
            }
            if (modeRestriction.length() > 0) {
                requeteur.setAttribut("DIFFUSION_MODE_RESTRICTION", modeRestriction);
            }
            if (publicViseRestriction.length() > 0) {
                requeteur.setAttribut("DIFFUSION_PUBLIC_VISE_RESTRICTION", publicViseRestriction);
            }
            String selection = RequeteUtil.renvoyerParametre(paramExit, "SELECTION");
            Date dateDebut = new Date(0L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String chaineDateDebut = RequeteUtil.renvoyerParametre(paramExit, "DATE_DEBUT");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{selection})) {
                dateDebut = AbstractRequeteur.renvoyerDateSelection(selection);
            }
            if (Formateur.estSaisie(dateDebut)) {
                chaineDateDebut = sdf.format(dateDebut) + chaineDateDebut;
            }
            if (chaineDateDebut.length() > 0) {
                requeteur.setAttribut("DATE_DEBUT", chaineDateDebut);
            }
            AttributRequeteur attributDateDebut = requeteur.getAttribut("DATE_DEBUT");
            requeteur.setAttribut("TYPE_DATE", "DATE_MODIFICATION", attributDateDebut.isRequetable(), attributDateDebut.isTriable());
            String chaineDateFin = RequeteUtil.renvoyerParametre(paramExit, "DATE_FIN");
            if (chaineDateFin.length() > 0) {
                requeteur.setAttribut("DATE_FIN", chaineDateFin);
            }
            if ((langue = RequeteUtil.renvoyerParametre(paramExit, "LANGUE")).length() > 0) {
                requeteur.setAttribut("LANGUE_FICHE", langue);
            }
            String tri = RequeteUtil.renvoyerParametre(paramExit, "TRI");
            String increment = RequeteUtil.renvoyerParametre(paramExit, "INCREMENT");
            int inc = 5;
            int nb = 0;
            try {
                inc = Integer.parseInt(increment);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tri.equals("5")) {
                nb = inc;
                inc = 0;
            }
            if (afficheListe || afficheTableau) {
                _ctx.getDatas().put("optimizedLimit", "1000");
                _ctx.setCalculListeResultatsFront(true);
                Map<String, MetatagBean> tMap = this.performRequest(requeteur, tri, inc);
                _ctx.setCalculListeResultatsFront(false);
                _ctx.getDatas().remove("optimizedLimit");
                if (afficheListe) {
                    String lastTypeFiche = "";
                    int compteur = 1;
                    for (MetatagBean bean : tMap.values()) {
                        boolean affiche = true;
                        String idFiche = bean.getMetaIdFiche().toString();
                        String typeFiche = bean.getMetaCodeObjet();
                        String nomObjet = ReferentielObjets.getNomObjet(typeFiche);
                        FicheUniv fiche = ReferentielObjets.instancierFiche(typeFiche);
                        String etatObjet = bean.getMetaEtatObjet();
                        String libelleFiche = bean.getMetaLibelleFiche();
                        if (tri.equals("5")) {
                            if (typeFiche.equals(lastTypeFiche)) {
                                ++compteur;
                            } else {
                                if (res.length() > 0) {
                                    res = res + "<br /><br />";
                                }
                                res = res + "<b>" + ReferentielObjets.getLibelleObjet(typeFiche) + "</b>";
                                compteur = 1;
                            }
                            if (compteur > nb) {
                                affiche = false;
                            }
                        }
                        if (!affiche) continue;
                        if (res.length() > 0 && separateur.equalsIgnoreCase("br")) {
                            res = res + "<br />";
                        } else if (separateur.equalsIgnoreCase("li")) {
                            res = res + "<li>";
                        } else if (res.length() > 0) {
                            res = res + "<br />";
                        }
                        String codeB = "";
                        if (mode.equals("VALID") || mode.equals("MODIF")) {
                            String parametres;
                            if (etatObjet.equals("0001")) {
                                codeB = " (B)";
                            } else if (etatObjet.equals("0002")) {
                                codeB = " (V)";
                            }
                            if (!FicheAnnotationHelper.isSaisieFrontOffice(fiche)) {
                                parametres = "EXT=" + ReferentielObjets.getExtension(typeFiche) + "&amp;PROC=" + ReferentielObjets.getProcessus(typeFiche) + "&amp;ACTION=MODIFIER&amp;ID_FICHE=" + idFiche;
                                res = _ctx.getAutorisation().possedeModeExpert() ? res + "<a " + classCss + " " + (StringUtils.isNotBlank((CharSequence)title) ? String.format("title=\"%s\" ", title) : "") + "href=\"#\" onclick=\"window.open('" + URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?" + parametres, _ctx) + "','_blank','');return false\">" + libelleFiche + "</a>" + codeB : res + libelleFiche + " (non modifiable)";
                            } else {
                                parametres = "/servlet/com.jsbsoft.jtf.core.SG?EXT=" + ReferentielObjets.getExtension(typeFiche) + "&amp;ACTION=MODIFIER&amp;SAISIE_FRONT=TRUE&amp;ID_FICHE=" + idFiche + "&amp;PROC=SAISIE_" + nomObjet.toUpperCase() + "_FRONT";
                                if (_ctx.getFicheCourante() != null) {
                                    parametres = parametres + "&amp;URL_REDIRECT=" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(_ctx, _ctx.getFicheCourante()), _ctx);
                                }
                                res = res + "<a " + classCss + " " + (StringUtils.isNotBlank((CharSequence)title) ? String.format("title=\"%s\" ", title) : "") + "href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlRelative(_ctx, parametres, true), _ctx) + "\">" + libelleFiche + "</a>" + codeB;
                            }
                        } else {
                            res = res + "<a " + classCss + " " + (StringUtils.isNotBlank((CharSequence)title) ? String.format("title=\"%s\" ", title) : "") + "href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(_ctx, nomObjet, bean.getMetaCode()), _ctx) + "\">" + libelleFiche + "</a>";
                        }
                        if (separateur.equalsIgnoreCase("li")) {
                            res = res + "</li>";
                        }
                        lastTypeFiche = typeFiche;
                    }
                }
                if (separateur.equalsIgnoreCase("li")) {
                    res = "<ul>" + res + "</ul>";
                }
                if (afficheTableau && tMap.size() > 0) {
                    if (res.length() > 0) {
                        res = res + "<br /><br />";
                    }
                    res = res + "<a " + (StringUtils.isNotBlank((CharSequence)title) ? String.format("title=\"%s\" ", title) : "") + "href=\"" + URLResolver.getAbsoluteUrl(requeteur.genererUrlRequete() + "&amp;RH=" + _ctx.getCodeRubriquePageCourante(), _ctx) + "\">" + lien + "</a>";
                }
            }
        }
        return res;
    }

    protected Map<String, MetatagBean> performRequest(AbstractRequeteur requeteur, String tri, int inc) throws Exception {
        CacheRequestManager cacheRequestManager = (CacheRequestManager)ApplicationContextManager.getCoreContextBean("cacheRequestManager");
        return (Map)cacheRequestManager.call("requeteurFicheCacheRequest", requeteur, tri, "", 0, inc, "1");
    }

    @Override
    public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        try {
            return this.interpreterTag(texteAInterpreter, baliseOuvrante, baliseFermante);
        }
        catch (Exception e) {
            return "";
        }
    }
}

