/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.tag.interpreteur.impl;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheAnnuaire;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.RequeteUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreteurMailto
extends AbstractInterpreteurTag {
    private static final Logger LOG = LoggerFactory.getLogger(InterpreteurMailto.class);
    protected static String baliseInterneOuvrante = "[mailto]";
    protected static String baliseInterneFermante = "[/mailto]";

    @Override
    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String contenuTagMailto = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseInterneOuvrante, (String)baliseInterneFermante);
        String texteInterprete = "";
        String mail = "";
        if (contenuTagMailto.startsWith("email=")) {
            mail = RequeteUtil.renvoyerParametre(contenuTagMailto, "email");
            if (mail.contains(";")) {
                mail = this.getAdresseMailFromAnnuaire(ctx, mail);
            }
        } else {
            mail = this.getAdresseMailFromAnnuaire(ctx, contenuTagMailto);
        }
        if (StringUtils.isNotBlank((CharSequence)mail) && mail.contains("@")) {
            String[] tmail = mail.split("@");
            String paramDepuisSubject = StringUtils.substringAfter((String)contenuTagMailto, (String)"subject=");
            if (StringUtils.contains((CharSequence)paramDepuisSubject, (CharSequence)"&body")) {
                paramDepuisSubject = StringUtils.substringBefore((String)paramDepuisSubject, (String)"&body");
            }
            String subject = EscapeString.unescapeHtml(paramDepuisSubject);
            String body = RequeteUtil.renvoyerParametre(EscapeString.unescapeHtml(contenuTagMailto), "body");
            texteInterprete = "javascript:melA('" + tmail[0] + "','" + EscapeString.escapeJavaScript(subject) + "','" + EscapeString.escapeJavaScript(body) + "','" + tmail[1] + "');";
        }
        if (StringUtils.isNotBlank((CharSequence)texteInterprete)) {
            texteInterprete = StringUtils.replace((String)texteAInterpreter, (String)(baliseInterneOuvrante + contenuTagMailto + baliseInterneFermante), (String)texteInterprete);
        }
        return texteInterprete;
    }

    @Override
    public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        String codeFiche = "";
        if ((texteAInterpreter = this.supprimerBalisesDuTexte(texteAInterpreter, baliseOuvrante, baliseFermante)).startsWith("email=")) {
            String mail = RequeteUtil.renvoyerParametre(texteAInterpreter, "email");
            if (mail.contains(";")) {
                codeFiche = mail.split(";")[1];
            }
        } else if (texteAInterpreter.contains(";")) {
            codeFiche = texteAInterpreter.split(";")[1];
        }
        if (StringUtils.isNotBlank((CharSequence)codeFiche)) {
            codeFiche = "[annuaire;" + codeFiche + ";0]";
        }
        return codeFiche;
    }

    protected String getAdresseMailFromAnnuaire(OMContext ctx, String code) {
        String[] arguments = code.split(";");
        String codeAnnuaire = "";
        if (arguments.length >= 2) {
            codeAnnuaire = arguments[1];
        }
        codeAnnuaire = StringUtils.replace((String)codeAnnuaire, (String)"%20", (String)" ");
        AnnuaireModele annuaire = null;
        try {
            annuaire = FicheAnnuaire.getFicheAnnuaire(codeAnnuaire, LangueUtil.getLangueLocale(ctx.getLocale()));
            if (annuaire == null && !LangueUtil.getLangueLocale(ctx.getLocale()).equals(LangueUtil.getLangueLocale(LangueUtil.getDefaultLocale()))) {
                annuaire = FicheAnnuaire.getFicheAnnuaire(codeAnnuaire, LangueUtil.getLangueLocale(LangueUtil.getDefaultLocale()));
            }
            if (annuaire == null) {
                annuaire = FicheAnnuaire.getFicheAnnuaire(codeAnnuaire);
            }
        }
        catch (Exception e) {
            LOG.error("Une erreur est survenue pendant la recherche de la fiche annuaire : ", (Throwable)e);
        }
        if (annuaire != null && annuaire.getEtatObjet().equals(EtatFiche.EN_LIGNE.getEtat()) && annuaire.getAdresseMail().length() > 0) {
            return annuaire.getAdresseMail();
        }
        return "";
    }
}

