/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.tag.interpreteur.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.kportal.cms.objetspartages.ObjetPartageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.frontoffice.util.JSPIncludeHelper;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.cache.CacheRequestManager;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class InterpreteurRequete
extends AbstractInterpreteurTag {
    @Override
    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        String retour = "";
        String param = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseOuvrante, (String)baliseFermante);
        param = StringEscapeUtils.unescapeHtml4((String)param);
        param = StringUtils.replace((String)param, (String)"#", (String)"&");
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        ctx.setCalculListeResultatsFront(true);
        List<ResultatRecherche> listeResultats = this.performRequest(param);
        ctx.setCalculListeResultatsFront(false);
        if (listeResultats.size() > 0) {
            if (ctx.getJspWriter() == null) {
                String resultatExit = "";
                for (ResultatRecherche res : listeResultats) {
                    FicheUniv fiche = RequeteUtil.lireFiche(res);
                    String urlFiche = UnivWebFmt.determinerUrlFiche(ctx, fiche);
                    resultatExit = resultatExit + "<a href=\"" + URLResolver.getAbsoluteUrl(urlFiche, ctx) + "\" class=\"txtcourant\">" + fiche.getLibelleAffichable() + "</a><br />";
                }
                retour = resultatExit;
            } else {
                int i = 0;
                FicheUniv fiche = null;
                while (fiche == null) {
                    fiche = RequeteUtil.lireFiche(listeResultats.get(i));
                    ++i;
                }
                if (fiche != null) {
                    String nomObjet = ReferentielObjets.getNomObjet(fiche);
                    String style = RequeteUtil.renvoyerParametre(param, "STYLE");
                    String affichage = PropertyHelper.getProperty(ReferentielObjets.getExtension(fiche), "fiche." + nomObjet.toUpperCase() + ".style_affichage");
                    String template = "";
                    if ("2".equals(affichage) || "1".equals(affichage) && style.length() > 0 || FicheUnivMgr.isFicheCollaborative(fiche)) {
                        template = ObjetPartageHelper.getTemplateObjet("requete_resultat", nomObjet.toLowerCase());
                    }
                    if (StringUtils.isEmpty((CharSequence)template)) {
                        template = ObjetPartageHelper.getTemplateObjet("requete_resultat", "default");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)template)) {
                        ctx.getRequeteHTTP().setAttribute("param", (Object)param);
                        ctx.getRequeteHTTP().setAttribute("listeFiches", listeResultats);
                        retour = JSPIncludeHelper.getOutputJsp(ctx.getJspWriter(), ctx.getServletContext(), ctx.getRequeteHTTP(), ctx.getReponseHTTP(), template);
                    }
                }
            }
        }
        return retour;
    }

    protected List<ResultatRecherche> performRequest(String param) throws Exception {
        CacheRequestManager cacheRequestManager = (CacheRequestManager)ApplicationContextManager.getCoreContextBean("cacheRequestManager");
        return (List)cacheRequestManager.call("objetsCacheRequest", param);
    }

    @Override
    public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        return "";
    }
}

