/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.tag.util;

import com.kportal.extension.module.plugin.toolbox.IPluginTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ContexteTagUtil {
    public static final String DEFAUT = "DEFAUT";
    public static final String INDEXATION = "INDEXATION";

    public static final Map<String, Collection<IPluginTag>> getTagsParContexte(Collection<IPluginTag> tagsAInterpreter) {
        Map<String, Collection<IPluginTag>> tagsParIdentifiant = new HashMap<String, Collection<IPluginTag>>();
        Set<String> contexteDesTags = ContexteTagUtil.getContexteDeTagsParDefaut();
        for (IPluginTag tagCourant : tagsAInterpreter) {
            tagsParIdentifiant = ContexteTagUtil.ajouterTagDansMap(tagsParIdentifiant, tagCourant.getIdentifiantTag(), tagCourant);
            if (tagCourant.getContexte().isEmpty()) {
                tagCourant.setContexteTag(Arrays.asList(DEFAUT));
            }
            contexteDesTags.addAll(tagCourant.getContexte());
        }
        Map<String, Collection<IPluginTag>> tagsAInterpreterParContexte = new HashMap<String, Collection<IPluginTag>>();
        for (Map.Entry tagsParId : tagsParIdentifiant.entrySet()) {
            for (String contexteDeTag : contexteDesTags) {
                IPluginTag tagPourContexteCourant = ContexteTagUtil.getTagPourContexteCourant(contexteDeTag, (Collection)tagsParId.getValue());
                if (tagPourContexteCourant == null) continue;
                tagsAInterpreterParContexte = ContexteTagUtil.ajouterTagDansMap(tagsAInterpreterParContexte, contexteDeTag, tagPourContexteCourant);
            }
        }
        return tagsAInterpreterParContexte;
    }

    private static Set<String> getContexteDeTagsParDefaut() {
        HashSet<String> contexteDeTags = new HashSet<String>();
        contexteDeTags.add(DEFAUT);
        contexteDeTags.add(INDEXATION);
        return contexteDeTags;
    }

    private static IPluginTag getTagPourContexteCourant(String contexteDeTag, Collection<IPluginTag> tagsPossible) {
        IPluginTag tagDuContexteCourant = null;
        IPluginTag tagDefaut = null;
        for (IPluginTag tag : tagsPossible) {
            if (tag.getContexte().contains(contexteDeTag)) {
                tagDuContexteCourant = tag;
            }
            if (!tag.getContexte().contains(DEFAUT)) continue;
            tagDefaut = tag;
        }
        if (tagDuContexteCourant == null && tagDefaut != null) {
            tagDuContexteCourant = tagDefaut;
        }
        return tagDuContexteCourant;
    }

    private static Map<String, Collection<IPluginTag>> ajouterTagDansMap(Map<String, Collection<IPluginTag>> mapAModifier, String cle, IPluginTag tagAAJouter) {
        Collection<IPluginTag> listeTagCourant = mapAModifier.get(cle);
        if (listeTagCourant == null) {
            listeTagCourant = new ArrayList<IPluginTag>();
            mapAModifier.put(cle, listeTagCourant);
        }
        listeTagCourant.add(tagAAJouter);
        return mapAModifier;
    }
}

