/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.util.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.lang3.StringUtils;

public class TarGz {
    private static final String TAR_EXTENSION = ".tar";
    private static final String GZ_EXTENSION = ".tar.gz";
    private static int BUFFER_SIZE = 8192;

    private static File getTypeFile(File source, File target, String extension) throws IOException {
        if (target.getName().toLowerCase().endsWith(extension)) {
            return target;
        }
        String tName = target.isDirectory() ? source.getName() : target.getName();
        int index = tName.lastIndexOf(46);
        return new File((target.isDirectory() ? target.getCanonicalPath() : target.getParentFile().getCanonicalPath()) + File.separatorChar + (index < 0 ? tName : tName.substring(0, index)) + extension);
    }

    private static File getTarFile(File compress) throws IOException {
        if (compress.getName().toLowerCase().endsWith(TAR_EXTENSION)) {
            return compress;
        }
        if (compress.getName().toLowerCase().endsWith(GZ_EXTENSION)) {
            return TarGz.getTarFile(new File(StringUtils.removeEnd((String)compress.getCanonicalPath(), (String)GZ_EXTENSION)));
        }
        return TarGz.getTypeFile(compress, compress, TAR_EXTENSION);
    }

    private static void tarFile(TarArchiveOutputStream out, String parentFolder, File file, boolean inclureParentFolder) throws IOException {
        String zipName = "";
        if (!file.isDirectory() || inclureParentFolder) {
            zipName = parentFolder + file.getName() + (file.isDirectory() ? "/" : "");
            TarArchiveEntry entry = new TarArchiveEntry(file, zipName);
            entry.setSize(file.length());
            entry.setModTime(file.lastModified());
            out.putArchiveEntry((ArchiveEntry)entry);
            if (!file.isDirectory()) {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    int bytesRead;
                    byte[] buf = new byte[BUFFER_SIZE];
                    while (-1 != (bytesRead = ((InputStream)in).read(buf))) {
                        out.write(buf, 0, bytesRead);
                    }
                }
            }
            out.closeArchiveEntry();
        }
        if (file.isDirectory()) {
            File[] tf;
            for (File element : tf = file.listFiles()) {
                TarGz.tarFile(out, zipName.toString(), element, true);
            }
        }
    }

    public static void compress(File file, File target, boolean inlureParentFolder, boolean deleteFileAfter) throws IOException {
        File source = file.getCanonicalFile();
        File tarFile = TarGz.getTypeFile(source, target.getCanonicalFile(), TAR_EXTENSION);
        TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)new FileOutputStream(tarFile));
        tarOut.setLongFileMode(2);
        tarOut.setBigNumberMode(1);
        TarGz.tarFile(tarOut, "", source, inlureParentFolder);
        tarOut.close();
        File gzFile = TarGz.getTypeFile(source, tarFile.getCanonicalFile(), GZ_EXTENSION);
        GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)new FileOutputStream(gzFile));
        TarGz.gzipFile(gzOut, "", tarFile);
        gzOut.close();
        tarFile.delete();
        if (deleteFileAfter) {
            source.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFiles(Collection<File> files, File archive, boolean deleteSourceFile) throws IOException {
        File saveFolder = archive.getParentFile();
        File tarFile = File.createTempFile("TMP_", TAR_EXTENSION, saveFolder);
        try {
            Throwable throwable;
            try (FileOutputStream fosTar = new FileOutputStream(tarFile);){
                throwable = null;
                try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)fosTar);){
                    tarOut.setLongFileMode(2);
                    tarOut.setBigNumberMode(1);
                    for (File file : files) {
                        if (!file.isFile()) continue;
                        String parentFolder = file.getParent() + "/";
                        TarGz.tarFile(tarOut, parentFolder, file, Boolean.FALSE);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            var6_6 = null;
            try (FileOutputStream fosGz = new FileOutputStream(archive);){
                throwable = null;
                try (GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)fosGz);){
                    TarGz.gzipFile(gzOut, "", tarFile);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var6_6 = throwable4;
                throw throwable4;
            }
            if (deleteSourceFile) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    file.delete();
                }
            }
        }
        finally {
            tarFile.delete();
        }
    }

    private static void gzipFile(GzipCompressorOutputStream gzOut, String string, File gzFile) throws IOException {
        if (gzFile.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(gzFile));
            byte[] buffer = new byte[BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                gzOut.write(buffer, 0, n);
            }
            ((InputStream)in).close();
        }
    }

    public static void compress(File file) throws IOException {
        TarGz.compress(file, file);
    }

    public static void compress(File file, File target) throws IOException {
        TarGz.compress(file, target, false, false);
    }

    public static void compress(String fileName, String targetName) throws IOException {
        TarGz.compress(new File(fileName), new File(targetName));
    }

    public static void compress(String fileName) throws IOException {
        TarGz.compress(new File(fileName), new File(fileName));
    }

    /*
     * Exception decompiling
     */
    private static void untar(File file, File folder, boolean deleteFileAfter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void decompress(File compress, File target, boolean deleteZipAfter) throws IOException {
        File tarFile = TarGz.getTarFile(compress);
        TarGz.ungzip(compress, tarFile);
        TarGz.untar(tarFile, target, deleteZipAfter);
    }

    private static void ungzip(File file, File target) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        BufferedInputStream in = new BufferedInputStream(fin);
        FileOutputStream out = new FileOutputStream(target);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
        byte[] buffer = new byte[BUFFER_SIZE];
        int n = 0;
        while (-1 != (n = gzIn.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.close();
        gzIn.close();
    }

    public static void decompress(String fileName, String folderName) throws IOException {
        TarGz.decompress(new File(fileName), new File(folderName), false);
    }

    public static void decompress(File file, boolean deleteZipAfter) throws IOException {
        TarGz.decompress(file.getCanonicalFile(), file.getCanonicalFile().getParentFile(), deleteZipAfter);
    }

    public static void decompress(String fileName, boolean deleteZipAfter) throws IOException {
        TarGz.decompress(new File(fileName), deleteZipAfter);
    }

    public static void decompress(File file) throws IOException {
        TarGz.decompress(file, file.getCanonicalFile().getParentFile(), false);
    }

    public static void decompress(String fileName) throws IOException {
        TarGz.decompress(new File(fileName));
    }
}

