/*
 * Decompiled with CFR 0.152.
 */
package com.kportal.util.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class Zip {
    private static final String ZIP_EXTENSION = ".zip";
    private static final int DEFAULT_LEVEL_COMPRESSION = -1;
    private static int BUFFER_SIZE = 8192;

    private static File getZipTypeFile(File source, File target) throws IOException {
        if (target.getName().toLowerCase().endsWith(ZIP_EXTENSION)) {
            return target;
        }
        String tName = target.isDirectory() ? source.getName() : target.getName();
        int index = tName.lastIndexOf(46);
        return new File((target.isDirectory() ? target.getCanonicalPath() : target.getParentFile().getCanonicalPath()) + File.separatorChar + (index < 0 ? tName : tName.substring(0, index)) + ZIP_EXTENSION);
    }

    private static final void compressFile(ZipArchiveOutputStream out, String parentFolder, File file, boolean inclureParentFolder) throws IOException {
        String zipName = "";
        if (!file.isDirectory() || inclureParentFolder) {
            zipName = parentFolder + file.getName() + (file.isDirectory() ? "/" : "");
            ZipArchiveEntry entry = new ZipArchiveEntry(file, zipName);
            entry.setSize(file.length());
            entry.setTime(file.lastModified());
            out.putArchiveEntry((ArchiveEntry)entry);
            if (!file.isDirectory()) {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    int bytesRead;
                    byte[] buf = new byte[BUFFER_SIZE];
                    while (-1 != (bytesRead = ((InputStream)in).read(buf))) {
                        out.write(buf, 0, bytesRead);
                    }
                }
            }
            out.closeArchiveEntry();
        }
        if (file.isDirectory()) {
            File[] tf;
            for (File element : tf = file.listFiles()) {
                Zip.compressFile(out, zipName.toString(), element, true);
            }
        }
    }

    public static void compress(File file, File target, int compressionLevel) throws IOException {
        Zip.compress(file, target, compressionLevel, true);
    }

    public static void compress(File file, File target, int compressionLevel, boolean inlureParentFolder) throws IOException {
        File source = file.getCanonicalFile();
        ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(Zip.getZipTypeFile(source, target.getCanonicalFile())));
        out.setMethod(8);
        out.setLevel(compressionLevel);
        Zip.compressFile(out, "", source, inlureParentFolder);
        out.close();
    }

    public static void compress(File file, int compressionLevel) throws IOException {
        Zip.compress(file, file, compressionLevel);
    }

    public static void compress(File file, File target) throws IOException {
        Zip.compress(file, target, -1);
    }

    public static void compress(File file, File target, boolean inclureParentFolder) throws IOException {
        Zip.compress(file, target, -1, inclureParentFolder);
    }

    public static void compress(File file) throws IOException {
        Zip.compress(file, file, -1);
    }

    public static void compress(String fileName, String targetName, int compressionLevel) throws IOException {
        Zip.compress(new File(fileName), new File(targetName), compressionLevel);
    }

    public static void compress(String fileName, int compressionLevel) throws IOException {
        Zip.compress(new File(fileName), new File(fileName), compressionLevel);
    }

    public static void compress(String fileName, String targetName) throws IOException {
        Zip.compress(new File(fileName), new File(targetName), -1);
    }

    public static void compress(String fileName) throws IOException {
        Zip.compress(new File(fileName), new File(fileName), -1);
    }

    /*
     * Exception decompiling
     */
    public static void decompress(File file, File folder, boolean deleteZipAfter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void decompress(String fileName, String folderName, boolean deleteZipAfter) throws IOException {
        Zip.decompress(new File(fileName), new File(folderName), deleteZipAfter);
    }

    public static void decompress(String fileName, String folderName) throws IOException {
        Zip.decompress(new File(fileName), new File(folderName), false);
    }

    public static void decompress(File file, boolean deleteZipAfter) throws IOException {
        Zip.decompress(file, file.getCanonicalFile().getParentFile(), deleteZipAfter);
    }

    public static void decompress(String fileName, boolean deleteZipAfter) throws IOException {
        Zip.decompress(new File(fileName), deleteZipAfter);
    }

    public static void decompress(File file) throws IOException {
        Zip.decompress(file, file.getCanonicalFile().getParentFile(), false);
    }

    public static void decompress(String fileName) throws IOException {
        Zip.decompress(new File(fileName));
    }
}

