/*
 * Decompiled with CFR 0.152.
 */
package com.univ.autocomplete.processus;

import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.jsbsoft.jtf.textsearch.util.RechercheUtilBO;
import com.univ.autocomplete.bean.AutoCompleteSuggestion;
import com.univ.autocomplete.processus.GestionAutoCompletion;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFicheAutoCompletion
extends GestionAutoCompletion {
    private static final Logger LOG = LoggerFactory.getLogger(MultiFicheAutoCompletion.class);
    public static final String ID_BEAN = "multiFicheAutoComplete";

    @Override
    public List<AutoCompleteSuggestion> traiterRechercheDepuisRequete(HttpServletRequest req) {
        List<AutoCompleteSuggestion> resultats = new ArrayList<AutoCompleteSuggestion>();
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (autorisations == null) {
            return resultats;
        }
        try {
            resultats = MultiFicheAutoCompletion.getResults(autorisations, RechercheUtilBO.traiterRecherche(autorisations, ""));
        }
        catch (Exception e) {
            LOG.error("Impossible d'executer la recherche", (Throwable)e);
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    private static List<AutoCompleteSuggestion> getResults(AutorisationBean autorisations, List<ResultatRecherche> liste) throws Exception {
        ArrayList<AutoCompleteSuggestion> resultats = new ArrayList<AutoCompleteSuggestion>();
        for (ResultatRecherche res : liste) {
            AutoCompleteSuggestion auto = new AutoCompleteSuggestion();
            auto.setData(res);
            auto.setValue(res.getTitre());
            resultats.add(auto);
        }
        return resultats;
    }

    @Override
    public String getKeyForCache() {
        String code = "anonyme";
        if (ContexteUtil.getContexteUniv() != null && StringUtils.isNotEmpty((CharSequence)ContexteUtil.getContexteUniv().getCode())) {
            code = ContexteUtil.getContexteUniv().getCode();
        }
        return String.format("%s_%s", ID_BEAN, code);
    }
}

