/*
 * Decompiled with CFR 0.152.
 */
package com.univ.autocomplete.servlet;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.univ.autocomplete.bean.AutoCompleteSuggestion;
import com.univ.autocomplete.bean.AutoCompletionObject;
import com.univ.autocomplete.cache.CacheAutoCompletionManager;
import com.univ.autocomplete.processus.GestionAutoCompletion;
import com.univ.autocomplete.utils.AutoCompletionManager;
import com.univ.autocomplete.utils.AutoCompletionUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompletionServlet
extends HttpServlet {
    private static final long serialVersionUID = -7982996758134619952L;
    private static final Logger LOG = LoggerFactory.getLogger(AutoCompletionServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        try {
            String query = StringUtils.defaultString((String)req.getParameter("query"));
            String autoCompletionBeanName = req.getParameter("BEAN_AUTO_COMPLETION");
            GestionAutoCompletion gestionAutoCompletion = AutoCompletionManager.getGestionAutoCompletion(autoCompletionBeanName);
            CacheAutoCompletionManager cacheAutoCompletionManager = (CacheAutoCompletionManager)ApplicationContextManager.getCoreContextBean("cacheAutoCompletionManager");
            List<AutoCompleteSuggestion> resultats = cacheAutoCompletionManager.traiterRecherche(query, gestionAutoCompletion, req);
            AutoCompletionObject autoComplete = new AutoCompletionObject();
            autoComplete.setQuery(query);
            autoComplete.setSuggestions(AutoCompletionUtils.filtrerResultats(resultats, query));
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().write(mapper.writeValueAsString((Object)autoComplete));
        }
        catch (Exception e) {
            LOG.error("Une erreur est survenue lors de la construction de la liste de propositions : " + e.getMessage());
        }
    }
}

