/*
 * Decompiled with CFR 0.152.
 */
package com.univ.batch;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.logging.DefaultRollingFileAppender;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class LogReport {
    private final Logger logger;
    private final String key;
    private String reportSubject;
    private final Level level;
    private boolean sendReportByMail;
    private String appenderMailKey;

    public Logger getLogger() {
        return this.logger;
    }

    public LogReport(String key) {
        this.logger = (Logger)LoggerFactory.getLogger((String)key);
        this.key = key;
        this.level = Level.INFO;
        this.sendReportByMail = false;
        this.reportSubject = "";
        this.initMail();
        this.initAppender();
    }

    public LogReport(String key, Level level, boolean sendReportByMail, String subject) {
        this.logger = (Logger)LoggerFactory.getLogger((String)key);
        this.key = key;
        this.level = level;
        this.sendReportByMail = sendReportByMail;
        this.reportSubject = subject;
        this.initMail();
        this.initAppender();
    }

    private void initMail() {
        String subject;
        String mail = PropertyHelper.getCoreProperty("batch." + this.key + ".mail");
        if ("1".equals(mail)) {
            this.sendReportByMail = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)(subject = PropertyHelper.getCoreProperty("batch." + this.key + ".mail.subject")))) {
            this.reportSubject = subject;
        }
    }

    private void initAppender() {
        try {
            if (this.logger.getAppender(this.key) == null) {
                DefaultRollingFileAppender appender = new DefaultRollingFileAppender(this.key);
                appender.setContext((Context)this.logger.getLoggerContext());
                appender.start();
                this.logger.addAppender((Appender)appender);
            }
            if (this.sendReportByMail) {
                this.appenderMailKey = this.key + "-mail";
                DefaultRollingFileAppender appenderMail = new DefaultRollingFileAppender(this.appenderMailKey, this.appenderMailKey + "-" + System.currentTimeMillis());
                appenderMail.setContext((Context)this.logger.getLoggerContext());
                appenderMail.setAppend(false);
                appenderMail.start();
                this.logger.addAppender((Appender)appenderMail);
            }
            this.logger.setLevel(this.level);
            this.logger.setAdditive(false);
        }
        catch (Exception e) {
            this.logger.error("Erreur d'initialisation du logger " + this.key + " : " + e.getMessage());
        }
    }

    public void info(String add) {
        this.logger.info(add);
    }

    public void error(String add) {
        this.logger.error(add);
    }

    public void debug(String add) {
        this.logger.debug(add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sendReportByMail) {
            FileAppender appenderMail = (FileAppender)this.logger.getAppender(this.appenderMailKey);
            try {
                File fLog;
                if (appenderMail != null && (fLog = new File(appenderMail.getFile())).exists()) {
                    JSBMailbox mailbox = new JSBMailbox(false);
                    String to = PropertyHelper.getCoreProperty("batch." + this.key + ".mail.to");
                    if (StringUtils.isEmpty((CharSequence)to)) {
                        to = PropertyHelper.getCoreProperty("mail.webmaster");
                    }
                    mailbox.sendSystemMsgWithAttachedFiles(to, this.reportSubject, "Ci-joint le rapport d'ex\u00e9cution du script " + this.key + ".", new String[]{appenderMail.getFile()});
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (appenderMail != null) {
                    this.logger.detachAppender((Appender)appenderMail);
                    appenderMail.stop();
                    if (!new File(appenderMail.getFile()).delete()) {
                        this.logger.error("Impossible de supprimer le fichier log {}", (Object)appenderMail.getFile());
                    }
                }
            }
        }
    }

    public String getLogFilename() {
        FileAppender appender = (FileAppender)this.logger.getAppender(this.key);
        return appender.getFile();
    }
}

