/*
 * Decompiled with CFR 0.152.
 */
package com.univ.batch;

import ch.qos.logback.classic.Level;
import com.univ.batch.LogReport;
import com.univ.batch.LogReporter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class LogReportThread
implements Runnable,
LogReporter {
    public Logger logger;

    @Override
    public void run() {
        LogReport logReport = new LogReport(this.getLogFileName(), this.getLogLevel(), this.isReportByMail(), this.getReportSubject());
        this.logger = logReport.getLogger();
        Long start = System.currentTimeMillis();
        this.logger.info("DEBUT " + this.getClass().getSimpleName());
        this.perform();
        Long duree = System.currentTimeMillis() - start;
        this.logger.info("FIN " + this.getClass().getSimpleName() + ", dur\u00e9e : " + String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(duree), TimeUnit.MILLISECONDS.toMinutes(duree) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duree)), TimeUnit.MILLISECONDS.toSeconds(duree) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duree))));
        logReport.close();
    }

    public abstract void perform();

    @Override
    public String getLogFileName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public String getReportSubject() {
        return "";
    }

    @Override
    public Level getLogLevel() {
        return Level.INFO;
    }

    @Override
    public String getLogDescription() {
        return "";
    }

    @Override
    public boolean isReportByMail() {
        return false;
    }
}

