/*
 * Decompiled with CFR 0.152.
 */
package com.univ.batch.exports;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteDao;
import com.univ.utils.ExportCsvUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRoles
extends LogReportJob
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ExportRoles.class);
    private static final String EXPORT_TYPE = "roles";
    private static final String CHEVRON = ">";

    @Override
    public void run() {
        HashMap<Locale, List<String>> contentByLocale = new HashMap<Locale, List<String>>();
        for (Locale locale : LangueUtil.getLocales()) {
            contentByLocale.put(locale, new LinkedList());
        }
        this.constitutionDonneesExport(contentByLocale);
        this.constitutionFichiersExport(contentByLocale);
        this.purge();
    }

    @Override
    public void perform() {
        this.run();
    }

    private void constitutionDonneesExport(Map<Locale, List<String>> contentByLocale) {
        LOG.info("Constitution des donn\u00e9es d'export de r\u00f4les pour chacune des langues");
        try (ContexteDao ctx = new ContexteDao();){
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.setCtx(ctx);
            utilisateur.init();
            utilisateur.select("");
            while (utilisateur.nextItem()) {
                String userInfos = this.getUserInfos(utilisateur);
                this.addRolesLine(userInfos, utilisateur.getRoles(), ";", contentByLocale);
                Vector<String> groupesUtilisateur = Groupeutilisateur.getVecteurGroupes(utilisateur.getCode());
                for (int i = 0; i < groupesUtilisateur.size(); ++i) {
                    InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(groupesUtilisateur.get(i));
                    if (groupe.getRoles().length() <= 0) continue;
                    this.addRolesLine(userInfos, groupe.getRoles(), this.getSuffixeHeritage(groupe), contentByLocale);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Erreur lors de la r\u00e9cup\u00e9ration des donn\u00e9es d'export de r\u00f4les", (Throwable)e);
        }
        LOG.info("Fin de la constitution des donn\u00e9es d'export de r\u00f4les");
    }

    private void constitutionFichiersExport(Map<Locale, List<String>> contentByLocale) {
        LOG.info("Constitution des fichiers d'export de r\u00f4les");
        for (Locale locale : LangueUtil.getLocales()) {
            List<String> datas = contentByLocale.get(locale);
            if (datas.isEmpty()) continue;
            String currentCtm = ExportCsvUtil.createNewExportFile(EXPORT_TYPE, locale);
            if (StringUtils.isNotEmpty((CharSequence)currentCtm) && !currentCtm.equals("error")) {
                try {
                    FileWriter fw = new FileWriter(new File(ExportCsvUtil.getExportFilePath(EXPORT_TYPE, locale)));
                    Throwable throwable = null;
                    try {
                        fw.write(MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_HEADER_CSV") + "\n");
                        for (String data : datas) {
                            fw.write(data);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fw == null) continue;
                        if (throwable != null) {
                            try {
                                fw.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fw.close();
                    }
                }
                catch (IOException e) {
                    LOG.error("Erreur lors de l'\u00e9criture du fichier d'export de r\u00f4les en locale " + locale, (Throwable)e);
                    if (ExportCsvUtil.rollbackExportFile(EXPORT_TYPE, locale, currentCtm)) continue;
                    LOG.error("Erreur lors du rollback du fichier d'export de r\u00f4les en locale " + locale);
                }
                continue;
            }
            LOG.error("Erreur lors de la cr\u00e9ation du fichier d'export de r\u00f4les en locale " + locale);
        }
        LOG.info("Fin de la constitution des fichiers d'export de r\u00f4les");
    }

    private void addRolesLine(String prefixe, String roles, String suffixe, Map<Locale, List<String>> contentByLocale) throws Exception {
        StringTokenizer st = new StringTokenizer(StringUtils.defaultString((String)roles), "[]");
        boolean i = false;
        while (st.hasMoreTokens()) {
            String codeRole;
            InfosRole infosRole;
            String val = st.nextToken();
            int indexPointVirgule = val.indexOf(59);
            if (indexPointVirgule == -1 || (infosRole = Role.renvoyerItemRole(codeRole = val.substring(0, indexPointVirgule))).getCode().length() <= 0) continue;
            String sPerimetre = val.substring(indexPointVirgule + 1);
            Perimetre perimetre = new Perimetre(sPerimetre);
            Perimetre perimetreAffectation = new Perimetre(perimetre.getCodeStructure(), perimetre.getCodeRubrique(), "", perimetre.getCodeGroupe(), "");
            Perimetre perimetrePermission = Perimetre.calculerPerimetrePermission(perimetreAffectation, new Perimetre(infosRole.getPerimetre()));
            for (Locale locale : contentByLocale.keySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(prefixe);
                sb.append(infosRole.getIntitule() + ";");
                String intitulePerimetre = "";
                if (perimetrePermission == null) {
                    intitulePerimetre = MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_PERIMETRE_INVALIDE");
                    sb.append(intitulePerimetre);
                    sb.append(intitulePerimetre);
                    sb.append(intitulePerimetre);
                } else {
                    intitulePerimetre = StringUtils.isEmpty((CharSequence)perimetrePermission.getCodeStructure()) ? MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_TOUTES") : (perimetrePermission.getCodeStructure().equals("-") ? MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_AUCUNE") : Structure.getFilAriane(perimetrePermission.getCodeStructure(), CHEVRON) + ";");
                    sb.append(intitulePerimetre);
                    intitulePerimetre = StringUtils.isEmpty((CharSequence)perimetrePermission.getCodeRubrique()) ? MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_TOUTES") : (perimetrePermission.getCodeRubrique().equals("-") ? MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_AUCUNE") : Rubrique.getFilAriane(perimetrePermission.getCodeRubrique(), CHEVRON) + ";");
                    sb.append(intitulePerimetre);
                    intitulePerimetre = StringUtils.isEmpty((CharSequence)perimetrePermission.getCodeGroupe()) ? MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_TOUS") : (perimetrePermission.getCodeGroupe().equals("-") ? MessageHelper.getCoreMessage(locale, "EXPORT_ROLES_AUCUN") : Groupedsi.getFilAriane(perimetrePermission.getCodeGroupe(), CHEVRON) + ";");
                    sb.append(intitulePerimetre);
                }
                sb.append(suffixe + ";\n");
                contentByLocale.get(locale).add(sb.toString());
            }
        }
    }

    private String getSuffixeHeritage(InfosGroupeDsi groupe) {
        return Groupedsi.getFilAriane(groupe.getCode(), CHEVRON) + ";";
    }

    private String getUserInfos(Utilisateur utilisateur) {
        StringBuilder userInfos = new StringBuilder();
        userInfos.append(utilisateur.getCode()).append(";");
        userInfos.append(utilisateur.getCodeLdap()).append(";");
        userInfos.append(utilisateur.getNom()).append(";");
        userInfos.append(utilisateur.getPrenom()).append(";");
        return userInfos.toString();
    }

    private void purge() {
        int days = PropertyHelper.getCorePropertyAsInt("export.roles.retention", 15);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(System.currentTimeMillis()));
        cal.add(5, -days);
        long datePurge = cal.getTimeInMillis();
        File folder = new File(ExportCsvUtil.getFolderSpecificPath(EXPORT_TYPE));
        if (folder.exists()) {
            for (File file : folder.listFiles()) {
                try {
                    BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (attributes.creationTime().toMillis() >= datePurge || file.delete()) continue;
                    LOG.error("Erreur lors de la suppression du fichier " + file.toPath());
                }
                catch (IOException e) {
                    LOG.error("Erreur lors de la suppression du fichier " + file.toPath(), (Throwable)e);
                }
            }
        }
    }
}

