/*
 * Decompiled with CFR 0.152.
 */
package com.univ.batch.imports;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.batch.imports.TXTFilter;
import com.univ.objetspartages.cache.CacheLibelleManager;
import com.univ.objetspartages.om.Libelle;
import com.univ.utils.Chaine;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;

public class ImportLibelles
extends LogReportJob {
    private static final String SELECTED_FILE = "SELECTED_FILE";
    static String sFolderOrFile = "";

    public void importFichier(File f, ContextePage _ctx) throws Exception {
        FileReader freader = new FileReader(f);
        CacheLibelleManager cache = (CacheLibelleManager)ApplicationContextManager.getCoreContextBean("cacheLibelleManager");
        try (BufferedReader fichLogique = new BufferedReader(freader);){
            Libelle l = new Libelle();
            l.setCtx(_ctx);
            String ligneLue = fichLogique.readLine();
            while (ligneLue != null) {
                String typeLibelle = "";
                String code = "";
                String libelle = "";
                String langue = "";
                StringTokenizer st = new StringTokenizer(ligneLue, ",");
                int ind = 0;
                while (st.hasMoreTokens()) {
                    String item = st.nextToken();
                    if (ind == 0) {
                        typeLibelle = this.enleverQuote(item);
                    }
                    if (ind == 1) {
                        code = this.enleverQuote(item);
                    }
                    if (ind == 2) {
                        libelle = this.enleverQuote(item);
                    }
                    if (ind == 3) {
                        langue = this.enleverQuote(item);
                    }
                    ++ind;
                }
                boolean isCodeValide = Boolean.TRUE;
                try {
                    Chaine.controlerCodeMetier(code);
                }
                catch (ErreurApplicative e) {
                    isCodeValide = Boolean.FALSE;
                }
                boolean isTypeValide = cache.getListeTypesLibelles().containsKey(typeLibelle);
                if (isCodeValide && isTypeValide && libelle.length() > 0 && langue.length() > 0) {
                    l.init();
                    ClauseWhere whereCodeLangueType = new ClauseWhere(ConditionHelper.egalVarchar("CODE", code));
                    whereCodeLangueType.and(ConditionHelper.egalVarchar("LANGUE", langue));
                    whereCodeLangueType.and(ConditionHelper.egalVarchar("TYPE", typeLibelle));
                    l.select(whereCodeLangueType.formaterSQL());
                    if (l.nextItem()) {
                        l.setLibelle(libelle);
                        l.update();
                        this.logger.debug("libell\u00e9 mis \u00e0 jour : " + libelle + "(code : " + code + ", langue : " + langue + ", type : " + CodeLibelle.lireLibelle(null, "type_libelle", typeLibelle) + ")");
                    } else if (l.select("WHERE LIBELLE='" + StringUtils.replace((String)libelle, (String)"'", (String)"\\'") + "' AND LANGUE='" + langue + "' AND TYPE='" + typeLibelle + "'") > 0) {
                        this.logger.debug("Le m\u00eame libell\u00e9 existe d\u00e9j\u00e0 avec un code diff\u00e9rent. Ce libell\u00e9 ('" + libelle + "', langue : " + langue + ", type :" + typeLibelle + ") n'est donc pas import\u00e9.");
                    } else {
                        Libelle.addLibelle(_ctx, typeLibelle, code, libelle, langue);
                        this.logger.debug("libell\u00e9 ajout\u00e9 : " + libelle + "(code : " + code + ", langue : " + langue + ", type : " + CodeLibelle.lireLibelle(null, "type_libelle", typeLibelle) + ")");
                    }
                }
                ligneLue = fichLogique.readLine();
            }
        }
    }

    @Override
    public void init(JobExecutionContext arg0) {
        sFolderOrFile = (String)arg0.getMergedJobDataMap().get((Object)SELECTED_FILE);
    }

    @Override
    public void perform() {
        try {
            ContextePage ctx = new ContextePage("");
            File folderorfile = new File(sFolderOrFile);
            File file = null;
            this.logger.debug(folderorfile.isDirectory() ? "Dossier " : "Fichier ");
            if (!folderorfile.exists()) {
                throw new Exception((folderorfile.isDirectory() ? "Dossier " : "Fichier ") + sFolderOrFile + " inexistant");
            }
            if (!folderorfile.canRead()) {
                throw new Exception((folderorfile.isDirectory() ? "Dossier " : "Fichier ") + sFolderOrFile + " non accessible en lecture");
            }
            if (folderorfile.isDirectory()) {
                File[] listeFiles;
                TXTFilter filtre = new TXTFilter();
                for (File listeFile : listeFiles = folderorfile.listFiles(filtre)) {
                    this.logger.debug("fichier : " + listeFile.getName());
                    this.importFichier(listeFile, ctx);
                }
            } else {
                file = folderorfile;
                this.importFichier(file, ctx);
            }
        }
        catch (Exception e) {
            this.logger.error("Erreur d'import de libell\u00e9s", (Throwable)e);
        }
    }

    private String enleverQuote(String chaine) {
        String res = chaine.trim();
        if (res.charAt(0) == '\'') {
            res = res.substring(1);
        }
        if (res.charAt(res.length() - 1) == '\'') {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }
}

